/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTConditionalExpression
extends CASTNode
implements IASTConditionalExpression,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTExpression negative;
    private IASTExpression positive;

    public CASTConditionalExpression() {
    }

    public CASTConditionalExpression(IASTExpression condition, IASTExpression positive, IASTExpression negative) {
        this.setLogicalConditionExpression(condition);
        this.setPositiveResultExpression(positive);
        this.setNegativeResultExpression(negative);
    }

    public IASTExpression getLogicalConditionExpression() {
        return this.condition;
    }

    public void setLogicalConditionExpression(IASTExpression expression) {
        this.condition = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(LOGICAL_CONDITION);
        }
    }

    public IASTExpression getPositiveResultExpression() {
        return this.positive;
    }

    public void setPositiveResultExpression(IASTExpression expression) {
        this.positive = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(POSITIVE_RESULT);
        }
    }

    public IASTExpression getNegativeResultExpression() {
        return this.negative;
    }

    public void setNegativeResultExpression(IASTExpression expression) {
        this.negative = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(NEGATIVE_RESULT);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.positive != null && !this.positive.accept(action)) {
            return false;
        }
        if (this.negative != null && !this.negative.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.condition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.condition = (IASTExpression)other;
        }
        if (child == this.positive) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.positive = (IASTExpression)other;
        }
        if (child == this.negative) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.negative = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        return CVisitor.getExpressionType(this);
    }
}

