/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    public static final int INT_SIZE = 4;
    public static final int CHUNK_SIZE = 4096;
    public static final int OFFSET_IN_CHUNK_MASK = 4095;
    public static final int BLOCK_HEADER_SIZE = 2;
    public static final int BLOCK_SIZE_DELTA = 8;
    public static final int MIN_BLOCK_DELTAS = 2;
    public static final int MAX_BLOCK_DELTAS = 512;
    public static final int MAX_MALLOC_SIZE = 4094;
    public static final int VERSION_OFFSET = 0;
    public static final int DATA_AREA = 2048;
    private static final int BLOCK_PREV_OFFSET = 2;
    private static final int BLOCK_NEXT_OFFSET = 6;
    private final File fLocation;
    private final boolean fReadOnly;
    private RandomAccessFile fFile;
    private boolean fExclusiveLock = false;
    private boolean fLocked;
    private boolean fIsMarkedIncomplete = false;
    private int fVersion;
    private final Chunk fHeaderChunk;
    private Chunk[] fChunks;
    private ChunkCache fCache;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;

    public Database(File location, ChunkCache cache, int version, boolean openReadOnly) throws CoreException {
        try {
            this.fLocation = location;
            this.fReadOnly = openReadOnly;
            this.fCache = cache;
            this.openFile();
            int nChunksOnDisk = (int)(this.fFile.length() / 4096L);
            this.fHeaderChunk = new Chunk(this, 0);
            this.fHeaderChunk.fLocked = true;
            if (nChunksOnDisk <= 0) {
                this.fVersion = version;
                this.fChunks = new Chunk[1];
            } else {
                this.fHeaderChunk.read();
                this.fVersion = this.fHeaderChunk.getInt(0);
                this.fChunks = new Chunk[nChunksOnDisk];
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private void openFile() throws FileNotFoundException {
        this.fFile = new RandomAccessFile(this.fLocation, this.fReadOnly ? "r" : "rw");
    }

    void read(ByteBuffer buf, int i) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().read(buf, i);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    void write(ByteBuffer buf, int i) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().write(buf, i);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    private void reopen(ClosedChannelException e, int attempt) throws ClosedChannelException, FileNotFoundException {
        if (e instanceof ClosedByInterruptException || attempt >= 20) {
            throw e;
        }
        this.openFile();
    }

    public void transferTo(FileChannel target) throws IOException {
        assert (this.fLocked);
        FileChannel from = this.fFile.getChannel();
        long nRead = 0L;
        long position = 0L;
        long size = from.size();
        while (position < size) {
            nRead = from.transferTo(position, 65536L, target);
            if (nRead == 0L) break;
            position += nRead;
        }
    }

    public int getVersion() throws CoreException {
        return this.fVersion;
    }

    public void setVersion(int version) throws CoreException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putInt(0, version);
        this.fVersion = version;
    }

    public void clear(int version) throws CoreException {
        assert (this.fExclusiveLock);
        this.removeChunksFromCache();
        this.fVersion = version;
        this.fHeaderChunk.clear(0, 4096);
        this.fChunks = new Chunk[1];
        try {
            this.fHeaderChunk.flush();
            this.fFile.getChannel().truncate(4096L);
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
        }
        this.freed = 0L;
        this.malloced = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null) {
                    this.fCache.remove(chunk);
                    this.fChunks[i] = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int offset) throws CoreException {
        if (offset < 4096) {
            return this.fHeaderChunk;
        }
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            assert (this.fLocked);
            int index = offset / 4096;
            Chunk chunk = this.fChunks[index];
            if (chunk == null) {
                ++this.cacheMisses;
                chunk = this.fChunks[index] = new Chunk(this, index);
                chunk.read();
            } else {
                ++this.cacheHits;
            }
            this.fCache.add(chunk, this.fExclusiveLock);
            return chunk;
        }
    }

    public int malloc(int datasize) throws CoreException {
        Chunk chunk;
        assert (this.fExclusiveLock);
        if (datasize < 0 || datasize > 4094) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString((String)"pdom.requestTooLarge"), (Throwable)new IllegalArgumentException()));
        }
        int needDeltas = (datasize + 2 + 8 - 1) / 8;
        if (needDeltas < 2) {
            needDeltas = 2;
        }
        int freeblock = 0;
        int useDeltas = needDeltas;
        while (useDeltas <= 512) {
            freeblock = this.getFirstBlock(useDeltas * 8);
            if (freeblock != 0) break;
            ++useDeltas;
        }
        if (freeblock == 0) {
            freeblock = this.createNewChunk();
            useDeltas = 512;
            chunk = this.getChunk(freeblock);
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, useDeltas * 8, freeblock);
        }
        int unusedDeltas = useDeltas - needDeltas;
        if (unusedDeltas >= 2) {
            this.addBlock(chunk, unusedDeltas * 8, freeblock + needDeltas * 8);
            useDeltas = needDeltas;
        }
        int usedSize = useDeltas * 8;
        chunk.putShort(freeblock, (short)(-usedSize));
        chunk.clear(freeblock + 2, usedSize - 2);
        this.malloced += (long)usedSize;
        return freeblock + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewChunk() throws CoreException {
        assert (this.fExclusiveLock);
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int oldLen = this.fChunks.length;
            Chunk chunk = new Chunk(this, oldLen);
            chunk.fDirty = true;
            Chunk[] newchunks = new Chunk[oldLen + 1];
            System.arraycopy(this.fChunks, 0, newchunks, 0, oldLen);
            newchunks[oldLen] = chunk;
            this.fChunks = newchunks;
            this.fCache.add(chunk, true);
            return oldLen * 4096;
        }
    }

    private int getFirstBlock(int blocksize) throws CoreException {
        assert (this.fLocked);
        return this.fHeaderChunk.getInt((blocksize / 8 - 2 + 1) * 4);
    }

    private void setFirstBlock(int blocksize, int block) throws CoreException {
        assert (this.fExclusiveLock);
        this.fHeaderChunk.putInt((blocksize / 8 - 2 + 1) * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        assert (this.fExclusiveLock);
        int prevblock = chunk.getInt(block + 2);
        int nextblock = chunk.getInt(block + 6);
        if (prevblock != 0) {
            this.putInt(prevblock + 6, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 2, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        assert (this.fExclusiveLock);
        chunk.putShort(block, (short)blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 2, 0);
        chunk.putInt(block + 6, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 2, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        assert (this.fExclusiveLock);
        int block = offset - 2;
        Chunk chunk = this.getChunk(block);
        short blocksize = -chunk.getShort(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(int offset, byte value) throws CoreException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        return this.getChunk(offset).getInt(offset);
    }

    public void put3ByteUnsignedInt(int offset, int value) throws CoreException {
        this.getChunk(offset).put3ByteUnsignedInt(offset, value);
    }

    public int get3ByteUnsignedInt(int offset) throws CoreException {
        return this.getChunk(offset).get3ByteUnsignedInt(offset);
    }

    public void putShort(int offset, short value) throws CoreException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(int offset) throws CoreException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(int offset, long value) throws CoreException {
        this.getChunk(offset).putLong(offset, value);
    }

    public long getLong(int offset) throws CoreException {
        return this.getChunk(offset).getLong(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        return this.getChunk(offset).getChar(offset);
    }

    public IString newString(String string) throws CoreException {
        if (string.length() > 2045) {
            return new LongString(this, string);
        }
        return new ShortString(this, string);
    }

    public IString newString(char[] chars) throws CoreException {
        if (chars.length > 2045) {
            return new LongString(this, chars);
        }
        return new ShortString(this, chars);
    }

    public IString getString(int offset) throws CoreException {
        int length = this.getInt(offset);
        if (length > 2045) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public void reportFreeBlocks() throws CoreException {
        System.out.println("Allocated size: " + this.fChunks.length * 4096);
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + ((long)(this.fChunks.length * 4096) - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            int block = this.getFirstBlock(bs);
            while (block != 0) {
                ++count;
                block = this.getInt(block + 6);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 8;
        }
    }

    public void close() throws CoreException {
        assert (this.fExclusiveLock);
        this.flush();
        this.removeChunksFromCache();
        this.fHeaderChunk.clear(0, 4096);
        this.fHeaderChunk.fDirty = false;
        this.fChunks = new Chunk[1];
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.fLocation;
    }

    void releaseChunk(Chunk chunk) {
        if (!chunk.fLocked) {
            this.fChunks[chunk.fSequenceNumber] = null;
        }
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setExclusiveLock() {
        this.fExclusiveLock = true;
        this.fLocked = true;
    }

    public void setLocked(boolean val) {
        this.fLocked = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void giveUpExclusiveLock(boolean flush) throws CoreException {
        if (this.fExclusiveLock) {
            try {
                ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    int i = 1;
                    while (i < this.fChunks.length) {
                        Chunk chunk = this.fChunks[i];
                        if (chunk != null) {
                            if (chunk.fCacheIndex < 0) {
                                if (chunk.fDirty) {
                                    dirtyChunks.add(chunk);
                                } else {
                                    chunk.fLocked = false;
                                    this.fChunks[i] = null;
                                }
                            } else if (chunk.fLocked) {
                                if (chunk.fDirty) {
                                    if (flush) {
                                        dirtyChunks.add(chunk);
                                    }
                                } else {
                                    chunk.fLocked = false;
                                }
                            } else assert (!chunk.fDirty);
                        }
                        ++i;
                    }
                }
                this.flushAndUnlockChunks(dirtyChunks, flush);
            }
            finally {
                this.fExclusiveLock = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws CoreException {
        assert (this.fLocked);
        if (this.fExclusiveLock) {
            try {
                this.giveUpExclusiveLock(true);
            }
            finally {
                this.setExclusiveLock();
            }
            return;
        }
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null && chunk.fDirty) {
                    dirtyChunks.add(chunk);
                }
                ++i;
            }
        }
        this.flushAndUnlockChunks(dirtyChunks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAndUnlockChunks(ArrayList<Chunk> dirtyChunks, boolean isComplete) throws CoreException {
        assert (!Thread.holdsLock(this.fCache));
        Chunk chunk = this.fHeaderChunk;
        synchronized (chunk) {
            if (!(this.fHeaderChunk.fDirty || isComplete && this.fIsMarkedIncomplete)) {
                return;
            }
            if (!dirtyChunks.isEmpty()) {
                this.markFileIncomplete();
                for (Chunk chunk2 : dirtyChunks) {
                    if (!chunk2.fDirty) continue;
                    chunk2.flush();
                }
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    for (Chunk chunk3 : dirtyChunks) {
                        chunk3.fLocked = false;
                        if (chunk3.fCacheIndex >= 0) continue;
                        this.fChunks[chunk3.fSequenceNumber] = null;
                    }
                }
            }
            if (isComplete && (this.fHeaderChunk.fDirty || this.fIsMarkedIncomplete)) {
                this.fHeaderChunk.putInt(0, this.fVersion);
                this.fHeaderChunk.flush();
                this.fIsMarkedIncomplete = false;
            }
        }
    }

    private void markFileIncomplete() throws CoreException {
        if (!this.fIsMarkedIncomplete) {
            this.fIsMarkedIncomplete = true;
            try {
                ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
                this.fFile.getChannel().write(buf, 0L);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new DBStatus(e));
            }
        }
    }

    public void resetCacheCounters() {
        this.cacheMisses = 0L;
        this.cacheHits = 0L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public long getSizeBytes() {
        try {
            return this.fFile.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }
}

