/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameterSpecialization
extends PDOMCPPSpecialization
implements ICPPParameter {
    private static final int NEXT_PARAM = 44;
    private static final int TYPE = 48;
    protected static final int RECORD_SIZE = 52;

    public PDOMCPPParameterSpecialization(PDOM pdom, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, int typeRecord) throws CoreException {
        super(pdom, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = pdom.getDB();
        db.putInt(this.record + 44, 0);
        db.putInt(this.record + 48, typeRecord);
    }

    public PDOMCPPParameterSpecialization(PDOM pdom, PDOMNode parent, ICPPParameter param, PDOMCPPParameter specialized, IType type) throws CoreException {
        super(pdom, parent, (ICPPSpecialization)((Object)param), specialized);
        Database db = pdom.getDB();
        db.putInt(this.record + 44, 0);
        try {
            if (type == null) {
                type = param.getType();
            }
            if (type != null) {
                PDOMNode typeNode = this.getLinkageImpl().addType(this, type);
                db.putInt(this.record + 48, typeNode != null ? typeNode.getRecord() : 0);
            }
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus((Throwable)e));
        }
    }

    public PDOMCPPParameterSpecialization(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 52;
    }

    public int getNodeType() {
        return 32;
    }

    public void setNextParameter(PDOMCPPParameterSpecialization nextParam) throws CoreException {
        int rec = nextParam != null ? nextParam.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 44, rec);
    }

    public PDOMCPPParameterSpecialization getNextParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 44);
        return rec != 0 ? new PDOMCPPParameterSpecialization(this.pdom, rec) : null;
    }

    public IType getType() throws DOMException {
        try {
            PDOMNode node = this.getLinkageImpl().getNode(this.pdom.getDB().getInt(this.record + 48));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    private ICPPParameter getParameter() {
        return (ICPPParameter)this.getSpecializedBinding();
    }

    public boolean hasDefaultValue() {
        return this.getParameter().hasDefaultValue();
    }

    public boolean isAuto() throws DOMException {
        return this.getParameter().isAuto();
    }

    public boolean isRegister() throws DOMException {
        return this.getParameter().isRegister();
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }
}

