/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.types;

import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.parser.ASTBinaryExprNode;
import org.eclipse.photran.internal.core.parser.ASTComplexConstNode;
import org.eclipse.photran.internal.core.parser.ASTDblConstNode;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTLogicalConstNode;
import org.eclipse.photran.internal.core.parser.ASTNestedExprNode;
import org.eclipse.photran.internal.core.parser.ASTOperatorNode;
import org.eclipse.photran.internal.core.parser.ASTRealConstNode;
import org.eclipse.photran.internal.core.parser.ASTStringConstNode;
import org.eclipse.photran.internal.core.parser.ASTUnaryExprNode;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.parser.Parser;

public class TypeChecker {
    private TypeChecker() {
    }

    public static Type getTypeOf(IExpr expression) {
        return new TypingVisitor().getTypeOf(expression);
    }

    protected static class TypingVisitor
    extends Parser.ASTVisitor {
        protected Type topType;

        protected TypingVisitor() {
        }

        public Type getTypeOf(IExpr expression) {
            expression.accept(this);
            return this.topType == null ? Type.UNKNOWN : this.topType;
        }

        public void visitASTBinaryExprNode(ASTBinaryExprNode node) {
            Type lhsType = this.getTypeOf(node.getLhsExpr());
            Type rhsType = this.getTypeOf(node.getRhsExpr());
            ASTOperatorNode op = node.getOperator();
            if (lhsType.equals(Type.UNKNOWN) || lhsType.equals(Type.TYPE_ERROR) || rhsType.equals(Type.UNKNOWN) || rhsType.equals(Type.TYPE_ERROR) || rhsType.equals(Type.VOID) || lhsType.equals(Type.VOID)) {
                this.topType = Type.TYPE_ERROR;
                return;
            }
            this.topType = op.hasPowerOp() || op.hasDivideOp() || op.hasMinusOp() || op.hasPlusOp() || op.hasTimesOp() ? this.checkNumericOperations(lhsType, rhsType) : (op.hasAndOp() || op.hasOrOp() || op.hasEqvOp() || op.hasNeqvOp() ? this.checkLogicalComparisons(lhsType, rhsType) : (op.hasGeOp() || op.hasGtOp() || op.hasLeOp() || op.hasLtOp() || op.hasEqOp() || op.hasNeOp() || op.hasEqEqOp() ? this.checkNumericComparison(lhsType, rhsType, op) : (op.hasConcatOp() ? (lhsType.equals(Type.CHARACTER) && lhsType.equals(rhsType) ? Type.CHARACTER : Type.UNKNOWN) : Type.UNKNOWN)));
        }

        private Type checkNumericOperations(Type lhsType, Type rhsType) {
            if (lhsType.equals(Type.LOGICAL) || lhsType.equals(Type.CHARACTER) || rhsType.equals(Type.LOGICAL) || rhsType.equals(Type.CHARACTER)) {
                return Type.TYPE_ERROR;
            }
            if (lhsType.equals(rhsType)) {
                return lhsType;
            }
            if (lhsType.equals(Type.INTEGER)) {
                return this.checkIntegerOperations(rhsType);
            }
            if (lhsType.equals(Type.REAL)) {
                return this.checkRealOperations(rhsType);
            }
            if (lhsType.equals(Type.COMPLEX)) {
                return this.checkComplexComparison(rhsType);
            }
            if (lhsType.equals(Type.DOUBLEPRECISION)) {
                return this.checkDoubleComparison(rhsType);
            }
            return Type.UNKNOWN;
        }

        private Type checkComplexComparison(Type rhsType) {
            if (rhsType.equals(Type.INTEGER) || rhsType.equals(Type.REAL) || rhsType.equals(Type.DOUBLEPRECISION)) {
                return Type.COMPLEX;
            }
            return Type.UNKNOWN;
        }

        private Type checkDoubleComparison(Type rhsType) {
            if (rhsType.equals(Type.INTEGER) || rhsType.equals(Type.REAL)) {
                return Type.DOUBLEPRECISION;
            }
            if (rhsType.equals(Type.COMPLEX)) {
                return Type.COMPLEX;
            }
            return Type.UNKNOWN;
        }

        private Type checkRealOperations(Type rhsType) {
            if (rhsType.equals(Type.INTEGER)) {
                return Type.REAL;
            }
            if (rhsType.equals(Type.DOUBLEPRECISION)) {
                return Type.DOUBLEPRECISION;
            }
            if (rhsType.equals(Type.COMPLEX)) {
                return Type.COMPLEX;
            }
            return Type.UNKNOWN;
        }

        private Type checkIntegerOperations(Type rhsType) {
            if (rhsType.equals(Type.REAL)) {
                return Type.REAL;
            }
            if (rhsType.equals(Type.COMPLEX)) {
                return Type.COMPLEX;
            }
            if (rhsType.equals(Type.DOUBLEPRECISION)) {
                return Type.DOUBLEPRECISION;
            }
            return Type.UNKNOWN;
        }

        private Type checkLogicalComparisons(Type lhsType, Type rhsType) {
            if (lhsType.equals(Type.LOGICAL) && rhsType.equals(Type.LOGICAL)) {
                return Type.LOGICAL;
            }
            return Type.TYPE_ERROR;
        }

        private Type checkNumericComparison(Type lhsType, Type rhsType, ASTOperatorNode op) {
            if (lhsType.equals(Type.LOGICAL) || lhsType.equals(Type.CHARACTER) || rhsType.equals(Type.LOGICAL) || rhsType.equals(Type.CHARACTER)) {
                return Type.TYPE_ERROR;
            }
            if (lhsType.equals(Type.COMPLEX) || rhsType.equals(Type.COMPLEX)) {
                if (op.hasEqEqOp() || op.hasEqOp() || op.hasNeOp()) {
                    return Type.LOGICAL;
                }
                return Type.TYPE_ERROR;
            }
            return Type.LOGICAL;
        }

        public void visitASTIntConstNode(ASTIntConstNode node) {
            this.topType = Type.INTEGER;
        }

        public void visitASTDblConstNode(ASTDblConstNode node) {
            this.topType = Type.DOUBLEPRECISION;
        }

        public void visitASTLogicalConstNode(ASTLogicalConstNode node) {
            this.topType = Type.LOGICAL;
        }

        public void visitASTNestedExprNode(ASTNestedExprNode node) {
            this.topType = this.getTypeOf(node.getExpr());
        }

        public void visitASTRealConstNode(ASTRealConstNode node) {
            this.topType = Type.REAL;
        }

        public void visitASTStringConstNode(ASTStringConstNode node) {
            this.topType = Type.CHARACTER;
        }

        public void visitASTComplexConstNode(ASTComplexConstNode node) {
            this.topType = Type.COMPLEX;
        }

        public void visitASTUnaryExprNode(ASTUnaryExprNode node) {
            Type operand = this.getTypeOf(node.getOperand());
            ASTOperatorNode operator = node.getOperator();
            this.topType = operand.equals(Type.CHARACTER) ? Type.TYPE_ERROR : (operator != null && operator.hasNotOp() ? (operand.equals(Type.LOGICAL) ? Type.LOGICAL : Type.TYPE_ERROR) : (operand.equals(Type.LOGICAL) ? Type.TYPE_ERROR : operand));
        }
    }
}

