/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor_vpg.contentassist;

import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.ui.editor_vpg.DefinitionMap;
import org.eclipse.photran.internal.ui.editor_vpg.IFortranEditorVPGTask;
import org.eclipse.photran.internal.ui.editor_vpg.contentassist.FortranCompletionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FortranCompletionProcessorVPGTask
implements IFortranEditorVPGTask {
    private final FortranCompletionProcessor fortranCompletionProcessor;

    FortranCompletionProcessorVPGTask(FortranCompletionProcessor fortranCompletionProcessor) {
        this.fortranCompletionProcessor = fortranCompletionProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(IFile file, IFortranAST ast, DefinitionMap<Definition> defMap) {
        if (ast == null) {
            return;
        }
        FortranCompletionProcessor fortranCompletionProcessor = this.fortranCompletionProcessor;
        synchronized (fortranCompletionProcessor) {
            try {
                final HashMap<String, TreeSet<Definition>> defs = this.fortranCompletionProcessor.defs;
                defs.clear();
                ast.accept((Parser.IASTVisitor)new Parser.GenericASTVisitor(){

                    public void visitASTNode(Parser.IASTNode node) {
                        if (ScopingNode.isScopingNode((Parser.IASTNode)node)) {
                            ScopingNode n = (ScopingNode)node;
                            String qualifier = DefinitionMap.getQualifier(n);
                            List allDefs = n.getAllDefinitions();
                            TreeSet set = (TreeSet)defs.get(qualifier);
                            if (set == null) {
                                set = new TreeSet();
                            }
                            set.addAll(allDefs);
                            defs.put(qualifier, set);
                        }
                        this.traverseChildren(node);
                    }
                });
            }
            catch (Throwable throwable) {}
        }
    }
}

