/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WorkspacePathEditor
extends ListEditor {
    private IProject project;
    private String dirChooserLabelText;

    protected WorkspacePathEditor() {
    }

    public WorkspacePathEditor(IProject project, String name, String labelText, String dirChooserLabelText, Composite parent) {
        parent = new Composite(parent, 0);
        this.init(name, labelText);
        this.project = project;
        this.dirChooserLabelText = dirChooserLabelText;
        this.createControl(parent);
    }

    protected String getNewInputObject() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.project, false, this.dirChooserLabelText);
        if (dialog.open() == 0) {
            IResource resource;
            Path result = null;
            Object[] res = dialog.getResult();
            if (res.length == 1) {
                result = (Path)res[0];
            }
            if (!(resource = ResourcesPlugin.getWorkspace().getRoot().findMember(result)).exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"The selected resource does not exist");
            } else if (!(resource instanceof IContainer)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"The selected resource is not a container");
            } else if (result != null) {
                return result.toOSString();
            }
        }
        return null;
    }

    protected String createList(String[] items) {
        return SearchPathProperties.createList((String[])items);
    }

    protected String[] parseString(String stringList) {
        return SearchPathProperties.parseString((String)stringList);
    }
}

