/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteBuildServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RemoteServicesProviderSelectionDialog
extends Dialog {
    private RemoteBuildServiceProvider fProvider;
    private Map<Integer, IRemoteServices> fComboIndexToRemoteServicesProviderMap = new HashMap<Integer, IRemoteServices>();
    private IRemoteServices fSelectedProvider;
    private Map<Integer, IRemoteConnection> fComboIndexToRemoteConnectionMap = new HashMap<Integer, IRemoteConnection>();
    private IRemoteConnection fSelectedConnection;

    public RemoteServicesProviderSelectionDialog(IServiceProvider provider, Shell parentShell) {
        super(parentShell);
        if (!(provider instanceof RemoteBuildServiceProvider)) {
            throw new IllegalArgumentException();
        }
        this.fProvider = (RemoteBuildServiceProvider)provider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.getString("RemoteServicesProviderSelectionDialog_0"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        container.setLayout((Layout)layout);
        Label providerLabel = new Label(container, 16384);
        providerLabel.setText(Messages.getString("RemoteServicesProviderSelectionDialog_1"));
        final Combo providerCombo = new Combo(container, 12);
        providerCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        IRemoteServices providerSelected = this.fProvider.getRemoteServices();
        IRemoteServices[] providers = PTPRemoteCorePlugin.getDefault().getAllRemoteServices();
        int toSelect = 0;
        int k = 0;
        while (k < providers.length) {
            providerCombo.add(providers[k].getName(), k);
            this.fComboIndexToRemoteServicesProviderMap.put(k, providers[k]);
            if (providerSelected != null && providerSelected.getName().compareTo(providers[k].getName()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        providerCombo.select(toSelect);
        this.fSelectedProvider = this.fComboIndexToRemoteServicesProviderMap.get(toSelect);
        Label connectionLabel = new Label(container, 16384);
        connectionLabel.setText(Messages.getString("RemoteServicesProviderSelectionDialog.0"));
        final Combo connectionCombo = new Combo(container, 12);
        connectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.populateConnectionCombo(connectionCombo);
        final Button newConnectionButton = new Button(container, 8);
        newConnectionButton.setText(Messages.getString("RemoteServicesProviderSelectionDialog.1"));
        this.updateNewConnectionButtonEnabled(newConnectionButton);
        newConnectionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IRemoteUIConnectionManager connectionManager = RemoteServicesProviderSelectionDialog.this.getUIConnectionManager();
                if (connectionManager != null) {
                    connectionManager.newConnection(RemoteServicesProviderSelectionDialog.this.getShell());
                }
                RemoteServicesProviderSelectionDialog.this.populateConnectionCombo(connectionCombo);
            }
        });
        providerCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = providerCombo.getSelectionIndex();
                RemoteServicesProviderSelectionDialog.this.fSelectedProvider = (IRemoteServices)RemoteServicesProviderSelectionDialog.this.fComboIndexToRemoteServicesProviderMap.get(selectionIndex);
                RemoteServicesProviderSelectionDialog.this.populateConnectionCombo(connectionCombo);
                RemoteServicesProviderSelectionDialog.this.updateNewConnectionButtonEnabled(newConnectionButton);
            }
        });
        connectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = connectionCombo.getSelectionIndex();
                RemoteServicesProviderSelectionDialog.this.fSelectedConnection = (IRemoteConnection)RemoteServicesProviderSelectionDialog.this.fComboIndexToRemoteConnectionMap.get(selectionIndex);
                RemoteServicesProviderSelectionDialog.this.updateNewConnectionButtonEnabled(newConnectionButton);
            }
        });
        return container;
    }

    private void updateNewConnectionButtonEnabled(Button button) {
        IRemoteUIConnectionManager connectionManager = this.getUIConnectionManager();
        button.setEnabled(connectionManager != null);
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteUIConnectionManager connectionManager = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fSelectedProvider).getUIConnectionManager();
        return connectionManager;
    }

    private void populateConnectionCombo(Combo connectionCombo) {
        connectionCombo.removeAll();
        IRemoteConnection connectionSelected = this.fProvider.getConnection();
        IRemoteConnection[] connections = this.fSelectedProvider.getConnectionManager().getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < connections.length) {
            connectionCombo.add(connections[k].getName(), k);
            this.fComboIndexToRemoteConnectionMap.put(k, connections[k]);
            if (connectionSelected != null && connectionSelected.getName().compareTo(connections[k].getName()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        connectionCombo.select(toSelect);
        this.fSelectedConnection = this.fComboIndexToRemoteConnectionMap.get(toSelect);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(750, 125);
    }

    protected void okPressed() {
        super.okPressed();
        this.fProvider.setRemoteToolsProviderID(this.fSelectedProvider.getId());
        this.fProvider.setRemoteToolsConnection(this.fSelectedConnection);
    }
}

