/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraph
implements ICallGraph {
    protected List<ICallGraphNode> nodes_ = new ArrayList<ICallGraphNode>();
    protected List<String> env_ = new ArrayList<String>();
    protected ICallGraphNode topEntry_ = null;
    protected ICallGraphNode botEntry_ = null;
    protected List<List<ICallGraphNode>> cycles_ = new ArrayList<List<ICallGraphNode>>();
    protected Stack<ICallGraphNode> order;

    @Override
    public void addNode(ICallGraphNode node) {
        for (ICallGraphNode n : this.nodes_) {
            if (!n.getFuncName().equals(node.getFuncName()) || !n.getFileName().equals(node.getFileName())) continue;
            return;
        }
        this.nodes_.add(node);
    }

    @Override
    public List<ICallGraphNode> getAllNodes() {
        return this.nodes_;
    }

    @Override
    public ICallGraphNode botEntry() {
        return this.botEntry_;
    }

    @Override
    public List<List<ICallGraphNode>> getCycles() {
        return this.cycles_;
    }

    protected ICallGraphNode getEnclosingFunc(IASTNode n) {
        IASTNode parent = n.getParent();
        while (parent != null) {
            if (parent instanceof IASTFunctionDefinition) {
                return this.getNode((IASTFunctionDefinition)parent);
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public List<String> getEnv() {
        return this.env_;
    }

    @Override
    public ICallGraphNode getNode(String fileName, String funcName) {
        ICallGraphNode tmp = null;
        for (ICallGraphNode node : this.nodes_) {
            if (!node.getFuncName().equals(funcName)) continue;
            tmp = node;
            if (!node.getFileName().equals(fileName)) continue;
            return node;
        }
        return tmp;
    }

    @Override
    public ICallGraphNode getNode(IASTFunctionDefinition fdef) {
        for (ICallGraphNode node : this.nodes_) {
            if (node.getFuncDef() != fdef) continue;
            return node;
        }
        return null;
    }

    @Override
    public ICallGraphNode topEntry() {
        return this.topEntry_;
    }

    @Override
    public void setBotEntry(ICallGraphNode node) {
        this.botEntry_ = node;
    }

    @Override
    public void setTopEntry(ICallGraphNode node) {
        this.topEntry_ = node;
    }

    @Override
    public void buildCG() {
        CGBuilder builder = new CGBuilder();
        builder.run();
        this.checkRecursive();
        this.otherOP();
    }

    public void checkRecursive() {
        List<ICallGraphNode> list;
        this.order = new Stack();
        this.DFS();
        this.RV_DFS();
        Hashtable<ICallGraphNode, List<ICallGraphNode>> recursions = new Hashtable<ICallGraphNode, List<ICallGraphNode>>();
        ICallGraphNode node = this.botEntry_;
        while (node != null) {
            ICallGraphNode pi = (ICallGraphNode)node.getAttr("pi");
            if (pi != null) {
                if (recursions.containsKey(pi)) {
                    list = (List)recursions.get(pi);
                    list.add(node);
                } else {
                    list = new ArrayList();
                    list.add(node);
                    recursions.put(pi, list);
                }
            }
            node = node.botNext();
        }
        Enumeration e = recursions.keys();
        while (e.hasMoreElements()) {
            ICallGraphNode root = (ICallGraphNode)e.nextElement();
            list = (List)recursions.get(root);
            if (!list.contains(root)) {
                list.add(root);
            }
            this.cycles_.add(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ((ICallGraphNode)i.next()).setRecursive(true);
            }
        }
        for (ICallGraphNode node2 : this.nodes_) {
            if (!node2.getCallees().contains(node2)) continue;
            list = new ArrayList();
            list.add(node2);
            this.cycles_.add(list);
            node2.setRecursive(true);
        }
    }

    protected void DFS() {
        for (ICallGraphNode node : this.nodes_) {
            node.setAttr("color", new Integer(0));
            node.removeAttr("pi");
        }
        for (ICallGraphNode node : this.nodes_) {
            int color = (Integer)node.getAttr("color");
            if (color != 0) continue;
            this.DFSVisit(node);
        }
    }

    protected void DFSVisit(ICallGraphNode node) {
        node.setAttr("color", new Integer(1));
        for (ICallGraphNode callee : node.getCallees()) {
            int color = (Integer)callee.getAttr("color");
            if (color != 0) continue;
            callee.setAttr("pi", node);
            this.DFSVisit(callee);
        }
        this.order.push(node);
    }

    protected void RV_DFS() {
        for (ICallGraphNode node : this.nodes_) {
            node.setAttr("color", new Integer(0));
            node.removeAttr("pi");
        }
        ICallGraphNode n = null;
        ICallGraphNode m = null;
        this.topEntry_ = this.order.peek();
        while (!this.order.empty()) {
            n = this.order.pop();
            n.setBotNext(m);
            if (m != null) {
                m.setTopNext(n);
            }
            m = n;
            int color = (Integer)n.getAttr("color");
            if (color != 0) continue;
            this.RV_DFSVisit(n);
        }
        n = this.botEntry_ = m;
        while (n != null) {
            ICallGraphNode pred = (ICallGraphNode)n.getAttr("pi");
            ICallGraphNode temp = null;
            while (pred != null) {
                temp = pred;
                pred = (ICallGraphNode)pred.getAttr("pi");
            }
            if (temp != null) {
                n.setAttr("pi", temp);
            }
            n = n.botNext();
        }
    }

    protected void RV_DFSVisit(ICallGraphNode node) {
        node.setAttr("color", new Integer(1));
        for (ICallGraphNode caller : node.getCallers()) {
            int color = (Integer)caller.getAttr("color");
            if (color != 0) continue;
            caller.setAttr("pi", node);
            this.RV_DFSVisit(caller);
        }
    }

    public void otherOP() {
    }

    @Override
    public void print() {
        for (ICallGraphNode node : this.nodes_) {
            System.out.print(String.valueOf(node.getFuncName()) + " calls: ");
            for (ICallGraphNode callee : node.getCallees()) {
                System.out.println(String.valueOf(callee.getFuncName()) + ", ");
            }
            System.out.println("");
            System.out.println("");
        }
    }

    class CGBuilder
    extends ASTVisitor {
        ICallGraphNode currentNode_;

        CGBuilder() {
        }

        public void run() {
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            for (ICallGraphNode this.currentNode_ : CallGraph.this.nodes_) {
                IASTFunctionDefinition func = this.currentNode_.getFuncDef();
                func.accept((ASTVisitor)this);
                ICallGraphNode enclosingFuncNode = CallGraph.this.getEnclosingFunc((IASTNode)func);
                if (enclosingFuncNode == null) continue;
                enclosingFuncNode.addCallee(this.currentNode_);
                this.currentNode_.addCaller(enclosingFuncNode);
            }
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFunctionCallExpression) {
                IASTFunctionCallExpression funcExpr = (IASTFunctionCallExpression)expression;
                IASTExpression funcname = funcExpr.getFunctionNameExpression();
                String signature = funcname.getRawSignature();
                ICallGraphNode fnode = CallGraph.this.getNode(this.currentNode_.getFileName(), signature);
                if (fnode != null) {
                    this.currentNode_.addCallee(fnode);
                    fnode.addCaller(this.currentNode_);
                }
            }
            return 3;
        }
    }
}

