/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Observable;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.AbstractEventManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.debug.core.pdi.request.IPDIBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDICommandRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIConditionBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDeleteBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDeleteVariableRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDisableBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEnableBreakpointRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGoRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDISetCurrentStackFrameRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStartDebuggerRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepFinishRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepIntoInstructionRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepIntoRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepOverInstructionRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepOverRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStepRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDITerminateRequest;
import org.eclipse.ptp.debug.sdm.core.proxy.ProxyDebugClient;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugLocator;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugArgsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointHitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugBreakpointSetEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugDataEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugErrorEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugInfoThreadsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugInitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugMemoryInfoEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugOKEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSetThreadSelectEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalExitEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSignalsEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackInfoDepthEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackframeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStepEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSuspendEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugTypeEvent;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugVarsEvent;

public class SDMEventManager
extends AbstractEventManager {
    public SDMEventManager(IPDISession session) {
        super(session);
    }

    public void update(Observable o, Object arg) {
        PDebugUtils.println((String)("Msg: SDMEventManager - update(): Event: " + ((IProxyDebugEvent)arg).toString()));
        IProxyDebugEvent event = (IProxyDebugEvent)arg;
        IPDIEventRequest request = this.getCurrentRequest();
        this.fireEvent(request, event);
        this.verifyEvent(request, event);
    }

    private IPDIEvent createSuspendedEvent(IPDISessionObject reason, int thread_id, int level, int depth, String[] vars) {
        if (depth > 1) {
            this.session.getTaskManager().setCanStepReturnTasks(true, reason.getTasks());
        }
        this.session.getTaskManager().setSuspendTasks(true, reason.getTasks());
        this.session.processSupsendedEvent(reason.getTasks().copy(), thread_id, vars);
        return this.session.getEventFactory().newSuspendedEvent(reason, vars, thread_id, level, depth);
    }

    private synchronized void fireEvent(IPDIEventRequest request, IProxyDebugEvent event) {
        BitList eTasks = ProxyDebugClient.decodeBitSet(event.getBitSet());
        PDebugUtils.println((String)("Msg: SDMEventManager - fireEvent(): event " + event));
        ArrayList<IPDIEvent> eventList = new ArrayList<IPDIEvent>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean add(IPDIEvent e) {
                PDebugUtils.println((String)("Msg: SDMEventManager - fireEvent(): added PDIEvent: " + e));
                return super.add(e);
            }
        };
        if (event instanceof IProxyDebugOKEvent) {
            if (request != null) {
                if (request instanceof IPDIGoRequest) {
                    this.session.getTaskManager().setSuspendTasks(false, eTasks);
                    this.session.processRunningEvent(eTasks.copy());
                    eventList.add((IPDIEvent)this.session.getEventFactory().newResumedEvent((IPDISessionObject)this.session, eTasks, 0));
                } else if (request instanceof IPDIStepRequest) {
                    int details = request instanceof IPDIStepIntoRequest ? 2 : (request instanceof IPDIStepOverRequest ? 1 : (request instanceof IPDIStepFinishRequest ? 5 : (request instanceof IPDIStepIntoInstructionRequest ? 4 : (request instanceof IPDIStepOverInstructionRequest ? 3 : 0))));
                    this.session.getTaskManager().setSuspendTasks(false, eTasks);
                    this.session.processRunningEvent(eTasks.copy());
                    eventList.add((IPDIEvent)this.session.getEventFactory().newResumedEvent((IPDISessionObject)this.session, eTasks, details));
                } else if (!(request instanceof IPDIEnableBreakpointRequest || request instanceof IPDIDisableBreakpointRequest || request instanceof IPDIConditionBreakpointRequest)) {
                    if (request instanceof IPDIDeleteBreakpointRequest) {
                        if (((IPDIBreakpointRequest)request).isAllowUpdate()) {
                            IPDIBreakpoint bpt = ((IPDIDeleteBreakpointRequest)request).getBreakpoint();
                            if (bpt == null) {
                                eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, "Delete Breakpoint Error", "No PDI breakpoint found")));
                            } else {
                                eventList.add((IPDIEvent)this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt)));
                            }
                        }
                    } else if (request instanceof IPDITerminateRequest) {
                        this.session.getTaskManager().setPendingTasks(false, eTasks);
                        this.session.getTaskManager().setTerminateTasks(true, eTasks);
                        eventList.add((IPDIEvent)this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newExitInfo(this.session, eTasks, 1)));
                        if (this.session.getTaskManager().isAllTerminated(this.session.getTasks())) {
                            eventList.add((IPDIEvent)this.session.getEventFactory().newDisconnectedEvent((IPDISessionObject)this.session, this.session.getTasks()));
                        }
                    } else if (request instanceof IPDIStartDebuggerRequest) {
                        eventList.add((IPDIEvent)this.session.getEventFactory().newConnectedEvent((IPDISessionObject)this.session, eTasks));
                    } else if (!(request instanceof IPDISetCurrentStackFrameRequest) && !(request instanceof IPDIDeleteVariableRequest)) {
                        boolean cfr_ignored_0 = request instanceof IPDICommandRequest;
                    }
                }
            }
        } else if (event instanceof IProxyDebugBreakpointSetEvent) {
            if (!(request instanceof IPDIBreakpointRequest) || !((IPDIBreakpointRequest)request).isAllowUpdate()) {
                IProxyDebugBreakpointSetEvent e = (IProxyDebugBreakpointSetEvent)event;
                IPDIBreakpoint bpt = this.session.getBreakpointManager().getBreakpoint(e.getBreakpointId());
                if (bpt == null) {
                    eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, "Set Breakpoint Error", "No PDI breakpoint found")));
                } else {
                    eventList.add((IPDIEvent)this.session.getEventFactory().newCreatedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt)));
                }
            }
        } else if (event instanceof IProxyDebugExitEvent) {
            IProxyDebugExitEvent e = (IProxyDebugExitEvent)event;
            this.session.getTaskManager().setPendingTasks(false, eTasks);
            this.session.getTaskManager().setTerminateTasks(true, eTasks);
            eventList.add((IPDIEvent)this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newExitInfo(this.session, eTasks, e.getExitStatus())));
            if (this.session.getTaskManager().isAllTerminated(this.session.getTasks())) {
                try {
                    this.session.exit();
                    eventList.add((IPDIEvent)this.session.getEventFactory().newDisconnectedEvent((IPDISessionObject)this.session, this.session.getTasks()));
                }
                catch (PDIException ex) {
                    eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, ex.getTasks(), 2, "Shutdown debugger error", ex.getMessage())));
                }
            }
        } else if (event instanceof IProxyDebugErrorEvent) {
            int actionType;
            IProxyDebugErrorEvent e = (IProxyDebugErrorEvent)event;
            if (request != null) {
                request.error(e.getErrorMessage());
            }
            if ((actionType = this.session.getDebugger().getErrorAction(e.getErrorCode())) == 2) {
                this.session.getTaskManager().setPendingTasks(false, eTasks);
                this.session.getTaskManager().setTerminateTasks(true, eTasks);
            }
            eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, actionType, "Internal Error", e.getErrorMessage())));
        } else if (!(event instanceof IProxyDebugInitEvent) && !(event instanceof IProxyDebugMemoryInfoEvent)) {
            if (event instanceof IProxyDebugSignalExitEvent) {
                IProxyDebugSignalExitEvent e = (IProxyDebugSignalExitEvent)event;
                this.session.getTaskManager().setPendingTasks(false, eTasks);
                this.session.getTaskManager().setTerminateTasks(true, eTasks);
                eventList.add((IPDIEvent)this.session.getEventFactory().newDestroyedEvent((IPDISessionObject)this.session.getEventFactory().newSignalInfo(this.session, eTasks, e.getSignalName(), e.getSignalMeaning(), null, null)));
                if (this.session.getTaskManager().isAllTerminated(this.session.getTasks())) {
                    try {
                        this.session.exit();
                        eventList.add((IPDIEvent)this.session.getEventFactory().newDisconnectedEvent((IPDISessionObject)this.session, this.session.getTasks()));
                    }
                    catch (PDIException ex) {
                        eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, ex.getTasks(), 2, "Shutdown debugger error", ex.getMessage())));
                    }
                }
            } else if (event instanceof IProxyDebugBreakpointHitEvent) {
                IProxyDebugBreakpointHitEvent e = (IProxyDebugBreakpointHitEvent)event;
                IPDIBreakpoint bpt = this.session.getBreakpointManager().getBreakpoint(e.getBreakpointId());
                if (bpt == null) {
                    eventList.add((IPDIEvent)this.session.getEventFactory().newErrorEvent((IPDISessionObject)this.session.getEventFactory().newErrorInfo(this.session, eTasks, 0, "Hit Breakpoint Error", "No PDI breakpoint found")));
                } else {
                    eventList.add(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newBreakpointInfo(this.session, eTasks, bpt), e.getThreadId(), 0, e.getDepth(), e.getChangedVars()));
                }
            } else if (event instanceof IProxyDebugSignalEvent) {
                IProxyDebugSignalEvent e = (IProxyDebugSignalEvent)event;
                ProxyDebugLocator loc = e.getFrame().getLocator();
                IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
                eventList.add(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newSignalInfo(this.session, eTasks, e.getSignalName(), e.getSignalMeaning(), null, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
            } else if (event instanceof IProxyDebugStepEvent) {
                IProxyDebugStepEvent e = (IProxyDebugStepEvent)event;
                ProxyDebugLocator loc = e.getFrame().getLocator();
                IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
                eventList.add(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newEndSteppingRangeInfo(this.session, eTasks, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
            } else if (event instanceof IProxyDebugSuspendEvent) {
                IProxyDebugSuspendEvent e = (IProxyDebugSuspendEvent)event;
                ProxyDebugLocator loc = e.getFrame().getLocator();
                IPDILocator locator = PDILocationFactory.newLocator((String)loc.getFile(), (String)loc.getFunction(), (int)loc.getLineNumber(), (BigInteger)loc.getAddress());
                eventList.add(this.createSuspendedEvent((IPDISessionObject)this.session.getEventFactory().newLocationReachedInfo(this.session, eTasks, locator), e.getThreadId(), e.getFrame().getLevel(), e.getDepth(), e.getChangedVars()));
            } else if (!(event instanceof IProxyDebugTypeEvent || event instanceof IProxyDebugVarsEvent || event instanceof IProxyDebugDataEvent || event instanceof IProxyDebugArgsEvent || event instanceof IProxyDebugInfoThreadsEvent || event instanceof IProxyDebugSetThreadSelectEvent || event instanceof IProxyDebugSignalsEvent || event instanceof IProxyDebugStackframeEvent)) {
                boolean cfr_ignored_1 = event instanceof IProxyDebugStackInfoDepthEvent;
            }
        }
        this.fireEvents(eventList.toArray(new IPDIEvent[0]));
    }

    private void verifyEvent(IPDIEventRequest request, IProxyDebugEvent result) {
        BitList eTasks;
        if (request != null && request.completed(eTasks = ProxyDebugClient.decodeBitSet(result.getBitSet()), (Object)result)) {
            request.done();
            this.notifyEventRequest(request);
        }
    }
}

