/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core.pdi.request;

import java.math.BigInteger;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrameDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.AbstractSetThreadSelectRequest;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugStackFrame;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugSetThreadSelectEvent;

public class SDMSetThreadSelectRequest
extends AbstractSetThreadSelectRequest {
    private IPDISession session;

    public SDMSetThreadSelectRequest(IPDISession session, BitList tasks, int id) {
        super(tasks, id);
        this.session = session;
    }

    public IPDIStackFrameDescriptor getStackFrame(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof Object[]) {
            Object[] returnValues = (Object[])obj;
            ProxyDebugStackFrame frame = (ProxyDebugStackFrame)returnValues[1];
            IPDILocator loc = PDILocationFactory.newLocator((String)frame.getLocator().getFile(), (String)frame.getLocator().getFunction(), (int)frame.getLocator().getLineNumber(), (BigInteger)frame.getLocator().getAddress());
            return this.session.getModelFactory().newStackFrameDescriptor(frame.getLevel(), loc);
        }
        throw new PDIException(qTasks, "No Stack frame found");
    }

    protected void storeResult(BitList rTasks, Object result) {
        if (result instanceof IProxyDebugSetThreadSelectEvent) {
            Object[] objs = new Object[]{new Integer(((IProxyDebugSetThreadSelectEvent)result).getThreadId()), ((IProxyDebugSetThreadSelectEvent)result).getFrame()};
            this.results.put(rTasks, objs);
        } else {
            this.storeUnknownResult(rTasks, result);
        }
    }
}

