/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;

public abstract class AbstractEventRequest
implements IPDIEventRequest {
    protected int status = 5;
    protected BitList tasks = null;
    protected String message = "";

    public AbstractEventRequest(BitList tasks) {
        this.tasks = tasks.copy();
    }

    public void cancel() {
        try {
            this.doFinish();
            this.status = 4;
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    public boolean completed(BitList cTasks, Object result) {
        this.tasks.andNot(cTasks);
        return this.tasks.isEmpty();
    }

    public void done() {
        try {
            this.doFinish();
            this.status = 3;
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    public void error(String message) {
        this.status = 1;
        this.message = message;
        try {
            this.doFinish();
        }
        catch (PDIException e) {
            this.message = String.valueOf(this.message) + " - " + e.getMessage();
        }
    }

    public void execute(IPDIDebugger debugger) {
        try {
            this.doExecute(debugger);
            this.status = 2;
        }
        catch (PDIException e) {
            this.error(e.getMessage());
        }
    }

    public String getErrorMessage() {
        return this.message;
    }

    public int getResponseAction() {
        return 1;
    }

    public int getStatus() {
        return this.status;
    }

    public BitList getTasks() {
        return this.tasks;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        String res = String.valueOf(this.getName()) + " in status [";
        switch (this.status) {
            case 1: {
                res = String.valueOf(res) + "ERROR";
                break;
            }
            case 2: {
                res = String.valueOf(res) + "RUNNING";
                break;
            }
            case 3: {
                res = String.valueOf(res) + "DONE";
                break;
            }
            case 4: {
                res = String.valueOf(res) + "CANCELLED";
                break;
            }
            default: {
                res = String.valueOf(res) + "UNKNOWN";
            }
        }
        return String.valueOf(res) + "] for " + BitList.showBitList((BitList)this.getTasks()) + ".";
    }

    protected abstract void doExecute(IPDIDebugger var1) throws PDIException;

    protected abstract void doFinish() throws PDIException;
}

