/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.breakpoint;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.debug.core.model.IPWatchpoint;
import org.eclipse.ptp.debug.internal.core.breakpoint.BreakpointMessages;
import org.eclipse.ptp.debug.internal.core.breakpoint.PBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PWatchpoint
extends PBreakpoint
implements IPWatchpoint {
    private static final String P_WATCHPOINT = "org.eclipse.ptp.debug.core.pWatchpointMarker";

    public PWatchpoint() {
    }

    public PWatchpoint(IResource resource, Map<?, ?> attributes, boolean add) throws CoreException {
        super(resource, PWatchpoint.getMarkerType(), attributes, add);
    }

    @Override
    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.write", true);
    }

    @Override
    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.read", false);
    }

    @Override
    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.ptp.debug.core.expression", "");
    }

    public static String getMarkerType() {
        return P_WATCHPOINT;
    }

    @Override
    protected String getMarkerMessage() throws CoreException {
        String format = BreakpointMessages.getString("PWatchpoint.3");
        if (this.isWriteType() && !this.isReadType()) {
            format = BreakpointMessages.getString("PWatchpoint.0");
        } else if (!this.isWriteType() && this.isReadType()) {
            format = BreakpointMessages.getString("PWatchpoint.1");
        } else if (this.isWriteType() && this.isReadType()) {
            format = BreakpointMessages.getString("PWatchpoint.2");
        }
        return String.valueOf(this.getJobSetFormat()) + " " + MessageFormat.format(BreakpointMessages.getString("PFunctinBreakpoint"), format);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }
}

