/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ptp.debug.core.model.IJumpToAddress;
import org.eclipse.ptp.debug.core.model.IJumpToLine;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPVariable;
import org.eclipse.ptp.debug.core.model.IRestart;
import org.eclipse.ptp.debug.core.model.IResumeWithoutSignal;
import org.eclipse.ptp.debug.core.model.IRunToAddress;
import org.eclipse.ptp.debug.core.model.IRunToLine;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITargetExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocator;
import org.eclipse.ptp.debug.internal.core.model.AbstractPVariable;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PExpression;
import org.eclipse.ptp.debug.internal.core.model.PThread;
import org.eclipse.ptp.debug.internal.core.model.PVariable;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PStackFrame
extends PDebugElement
implements IPStackFrame,
IRestart,
IResumeWithoutSignal,
IPDIEventListener {
    private IPDIStackFrame pdiStackFrame;
    private IPDIStackFrame lastPDIStackFrame;
    private PThread fThread;
    private List<IPVariable> fVariables;
    private boolean fRefreshVariables = true;
    private List<PExpression> fExpressions;
    private boolean fIsDisposed = false;

    protected static boolean equalFrame(IPDIStackFrame frameOne, IPDIStackFrame frameTwo) {
        if (frameOne == null || frameTwo == null) {
            return false;
        }
        IPDILocator loc1 = frameOne.getLocator();
        IPDILocator loc2 = frameTwo.getLocator();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getFile() != null && loc1.getFile().length() > 0 && loc2.getFile() != null && loc2.getFile().length() > 0 && loc1.getFile().equals(loc2.getFile()) && loc1.getFunction() != null && loc1.getFunction().length() > 0 && loc2.getFunction() != null && loc2.getFunction().length() > 0 && loc1.getFunction().equals(loc2.getFunction())) {
            return true;
        }
        if (!(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() == null || loc1.getFunction().length() <= 0 || loc2.getFunction() == null || loc2.getFunction().length() <= 0 || !loc1.getFunction().equals(loc2.getFunction()))) {
            return true;
        }
        return !(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() != null && loc1.getFunction().length() >= 1 || loc2.getFunction() != null && loc2.getFunction().length() >= 1 || loc1.getAddress() != loc2.getAddress());
    }

    public PStackFrame(PThread thread, IPDIStackFrame pdiFrame) {
        super(thread.getSession(), thread.getTasks());
        this.setPDIStackFrame(pdiFrame);
        this.setThread(thread);
        this.getPDISession().getEventManager().addEventListener(this);
    }

    @Override
    public boolean canEvaluate() {
        return this.getDebugTarget().isSuspended();
    }

    @Override
    public boolean canJumpToAddress(BigInteger address) {
        return this.getThread().canResume();
    }

    @Override
    public boolean canJumpToLine(IFile file, int lineNumber) {
        return this.getThread().canResume();
    }

    @Override
    public boolean canJumpToLine(String fileName, int lineNumber) {
        return this.getThread().canResume();
    }

    @Override
    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && this.getDebugTarget().canRestart();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && this.getDebugTarget().canResumeWithoutSignal();
    }

    @Override
    public boolean canRunToAddress(BigInteger address) {
        return this.getThread().canResume();
    }

    @Override
    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.getThread().canResume();
    }

    @Override
    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.getThread().canResume();
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        block4: {
            if (this.exists()) break block4;
            return false;
        }
        try {
            List<IStackFrame> frames = ((PThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                return !bottomFrame && this.getThread().canStepReturn();
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    @Override
    public IValue evaluateExpression(String expressionText) throws DebugException {
        PExpression expression;
        if (!this.isDisposed() && (expression = this.getExpression(expressionText)) != null) {
            return expression.getValue(this);
        }
        return null;
    }

    @Override
    public String evaluateExpressionToString(String expression) throws DebugException {
        try {
            return this.getPDITarget().evaluateExpressionToString(this.getPDIStackFrame(), expression);
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
            return null;
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRunToLine.class) {
            return this;
        }
        if (adapter == IRunToAddress.class) {
            return this;
        }
        if (adapter == IJumpToLine.class) {
            return this;
        }
        if (adapter == IJumpToAddress.class) {
            return this;
        }
        if (adapter == IPStackFrame.class) {
            return this;
        }
        if (adapter == IStackFrame.class) {
            return this;
        }
        if (adapter == IPDIStackFrame.class) {
            return this.getPDIStackFrame();
        }
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public BigInteger getAddress() {
        return this.getPDIStackFrame().getLocator().getAddress();
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    @Override
    public PDebugTarget getDebugTarget() {
        return this.fThread.getDebugTarget();
    }

    @Override
    public String getFile() {
        return this.getPDIStackFrame().getLocator().getFile();
    }

    @Override
    public int getFrameLineNumber() {
        return this.getPDIStackFrame().getLocator().getLineNumber();
    }

    @Override
    public String getFunction() {
        return this.getPDIStackFrame().getLocator().getFunction();
    }

    @Override
    public int getLevel() {
        return this.getPDIStackFrame().getLevel();
    }

    public int getLineNumber() throws DebugException {
        if (this.isSuspended()) {
            ISourceLocator locator = this.getLaunch().getSourceLocator();
            if (locator != null && locator instanceof IAdaptable && ((IAdaptable)locator).getAdapter(IPSourceLocator.class) != null) {
                return ((IPSourceLocator)((IAdaptable)locator).getAdapter(IPSourceLocator.class)).getLineNumber(this);
            }
            if (this.getPDIStackFrame() != null && this.getPDIStackFrame().getLocator() != null) {
                return this.getPDIStackFrame().getLocator().getLineNumber();
            }
        }
        return -1;
    }

    public String getName() throws DebugException {
        IPDILocator locator = this.getPDIStackFrame().getLocator();
        String func = "";
        String file = "";
        String line = "";
        if (locator.getFunction() != null && locator.getFunction().trim().length() > 0) {
            func = String.valueOf(func) + locator.getFunction() + "() ";
        }
        if (locator.getFile() != null && locator.getFile().trim().length() > 0) {
            file = locator.getFile();
            if (locator.getLineNumber() != 0) {
                line = NumberFormat.getInstance().format(new Integer(locator.getLineNumber()));
            }
        } else {
            return func;
        }
        return MessageFormat.format(CoreModelMessages.getString("PStackFrame.0"), func, file, line);
    }

    @Override
    public IPDIStackFrame getPDIStackFrame() {
        return this.pdiStackFrame;
    }

    @Override
    public IPDIThread getPDIThread() {
        return ((PThread)this.getThread()).getPDIThread();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.isDisposed() ? new IRegisterGroup[]{} : this.fSession.getRegisterManager().getRegisterGroups(this.getTasks(), this);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.isDisposed()) {
            return new IVariable[0];
        }
        IPGlobalVariable[] globals = this.getGlobals();
        List<IPVariable> vars = this.getVariables0();
        ArrayList<IPVariable> all = new ArrayList<IPVariable>(globals.length + vars.size());
        all.addAll(Arrays.asList(globals));
        all.addAll(vars);
        return all.toArray(new IVariable[all.size()]);
    }

    @Override
    public void handleDebugEvents(IPDIEvent[] events) {
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.isDisposed() ? false : this.getDebugTarget().fSession.getRegisterManager().getRegisterGroups(this.getTasks(), this).length > 0;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    @Override
    public void jumpToAddress(BigInteger address) throws DebugException {
        if (!this.canJumpToAddress(address)) {
            return;
        }
        IPDIAddressLocation location = this.getPDISession().getBreakpointManager().createAddressLocation(address);
        try {
            this.getPDISession().resume(this.getTasks(), location);
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public void jumpToLine(IFile file, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(file, lineNumber)) {
            return;
        }
        this.jumpToLine(file.getLocation().lastSegment(), lineNumber);
    }

    @Override
    public void jumpToLine(String fileName, int lineNumber) throws DebugException {
        if (!this.canJumpToLine(fileName, lineNumber)) {
            return;
        }
        IPDILineLocation location = this.getPDISession().getBreakpointManager().createLineLocation(fileName, lineNumber);
        try {
            this.getPDISession().resume(this.getTasks(), location);
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public void restart() throws DebugException {
        if (this.canRestart()) {
            this.getDebugTarget().restart();
        }
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            this.getDebugTarget().resumeWithoutSignal();
        }
    }

    @Override
    public void runToAddress(BigInteger address, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToAddress(address)) {
            return;
        }
        if (skipBreakpoints) {
            this.fSession.getBreakpointManager().skipBreakpoints(true);
        }
        IPDIAddressLocation location = this.getPDISession().getBreakpointManager().createAddressLocation(address);
        try {
            this.getPDISession().stepUntil(this.getTasks(), location);
        }
        catch (PDIException e) {
            if (skipBreakpoints) {
                this.fSession.getBreakpointManager().skipBreakpoints(false);
            }
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(file, lineNumber)) {
            return;
        }
        this.runToLine(file.getLocation().lastSegment(), lineNumber, skipBreakpoints);
    }

    @Override
    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(fileName, lineNumber)) {
            return;
        }
        if (skipBreakpoints) {
            this.fSession.getBreakpointManager().skipBreakpoints(true);
        }
        IPDILineLocation location = this.getPDISession().getBreakpointManager().createLineLocation(fileName, lineNumber);
        try {
            this.getPDISession().stepUntil(this.getTasks(), location);
        }
        catch (PDIException e) {
            if (skipBreakpoints) {
                this.fSession.getBreakpointManager().skipBreakpoints(false);
            }
            PStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.getThread().stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.getThread().stepReturn();
        }
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            return e.getLocalizedMessage();
        }
    }

    private synchronized PExpression getExpression(String expressionText) throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList<PExpression>(5);
        }
        PExpression expression2 = null;
        for (PExpression expression2 : this.fExpressions) {
            if (expression2.getExpressionText().compareTo(expressionText) != 0) continue;
            return expression2;
        }
        try {
            IPDITargetExpression pdiExpression = this.getPDISession().getExpressionManager().createExpression(this.getTasks(), expressionText);
            expression2 = new PExpression(this, pdiExpression, null);
            this.fExpressions.add(expression2);
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return expression2;
    }

    private IPGlobalVariable[] getGlobals() {
        return new IPGlobalVariable[0];
    }

    private void preserveExpressions() {
        if (this.fExpressions == null) {
            return;
        }
        for (PExpression exp : this.fExpressions) {
            exp.preserve();
        }
    }

    private void preserveVariables() {
        if (this.fVariables == null) {
            return;
        }
        for (AbstractPVariable abstractPVariable : this.fVariables) {
            abstractPVariable.preserve();
        }
    }

    private boolean refreshVariables() {
        return this.fRefreshVariables;
    }

    private void setDisposed(boolean isDisposed) {
        this.fIsDisposed = isDisposed;
    }

    private void setRefreshVariables(boolean refresh) {
        this.fRefreshVariables = refresh;
    }

    protected void dispose() {
        this.setDisposed(true);
        this.getPDISession().getEventManager().removeEventListener(this);
        this.disposeAllVariables();
        this.disposeExpressions();
    }

    protected void disposeAllVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator<IPVariable> it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((PVariable)it.next()).dispose();
        }
        this.fVariables.clear();
        this.fVariables = null;
    }

    protected void disposeExpressions() {
        if (this.fExpressions != null) {
            Iterator<PExpression> it = this.fExpressions.iterator();
            while (it.hasNext()) {
                it.next().dispose();
            }
            this.fExpressions.clear();
        }
        this.fExpressions = null;
    }

    protected void doStepReturn() throws DebugException {
        try {
            this.getPDISession().stepReturn(this.getTasks(), 0);
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected boolean exists() throws DebugException {
        return ((PThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    protected IPDIVariableDescriptor findVariable(List<IPDIVariableDescriptor> list, PVariable var) {
        for (IPDIVariableDescriptor newVarObject : list) {
            if (!var.sameVariable(newVarObject)) continue;
            return newVarObject;
        }
        return null;
    }

    protected List<IPDIVariableDescriptor> getAllPDIVariableObjects() throws DebugException {
        ArrayList<IPDIVariableDescriptor> list = new ArrayList<IPDIVariableDescriptor>();
        list.addAll(this.getPDIArgumentObjects());
        list.addAll(this.getPDILocalVariableObjects());
        return list;
    }

    protected IPDIStackFrame getLastPDIStackFrame() {
        return this.lastPDIStackFrame;
    }

    protected List<IPDIVariableDescriptor> getPDIArgumentObjects() throws DebugException {
        ArrayList<IPDIVariableDescriptor> list = new ArrayList<IPDIVariableDescriptor>();
        try {
            list.addAll(Arrays.asList(this.getPDIStackFrame().getArgumentDescriptors()));
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List<IPDIVariableDescriptor> getPDILocalVariableObjects() throws DebugException {
        ArrayList<IPDIVariableDescriptor> list = new ArrayList<IPDIVariableDescriptor>();
        try {
            list.addAll(Arrays.asList(this.getPDIStackFrame().getLocalVariableDescriptors()));
        }
        catch (PDIException e) {
            PStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected synchronized List<IPVariable> getVariables0() throws DebugException {
        if (this.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        PThread thread = (PThread)this.getThread();
        if (thread.isSuspended()) {
            if (this.fVariables == null) {
                List<IPDIVariableDescriptor> vars = this.getAllPDIVariableObjects();
                this.fVariables = new ArrayList<IPVariable>(vars.size());
                Iterator<IPDIVariableDescriptor> it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(PVariableFactory.createLocalVariable(this, it.next()));
                }
            } else if (this.refreshVariables()) {
                this.updateVariables();
            }
            this.setRefreshVariables(false);
        }
        return this.fVariables != null ? this.fVariables : Collections.EMPTY_LIST;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    protected synchronized void preserve() {
        this.preserveVariables();
        this.preserveExpressions();
    }

    protected void setPDIStackFrame(IPDIStackFrame frame) {
        this.lastPDIStackFrame = frame != null ? frame : this.pdiStackFrame;
        this.pdiStackFrame = frame;
        this.setRefreshVariables(true);
    }

    protected void setThread(PThread thread) {
        this.fThread = thread;
    }

    protected void updateVariables() throws DebugException {
        List<IPDIVariableDescriptor> locals = this.getAllPDIVariableObjects();
        int index = 0;
        while (index < this.fVariables.size()) {
            IPDIVariableDescriptor varObject = this.findVariable(locals, (PVariable)this.fVariables.get(index));
            if (varObject != null) {
                locals.remove(varObject);
                ++index;
                continue;
            }
            this.fVariables.remove(index);
        }
        Iterator<IPDIVariableDescriptor> newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            this.fVariables.add(PVariableFactory.createLocalVariable(this, newOnes.next()));
        }
    }
}

