/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPGLog<T, R extends TokenRef<T>> {
    private VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> vpg = null;
    protected List<Entry> log = new LinkedList<Entry>();
    private Set<ILogListener> listeners = new HashSet<ILogListener>();

    public void setVPG(VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> vpg) {
        this.vpg = vpg;
    }

    protected VPG<?, T, R, ? extends VPGDB<?, T, R, ?>, ? extends VPGLog<T, R>> getVPG() {
        if (this.vpg == null) {
            throw new IllegalStateException("This VPG database has not been assigned to a VPG.  Construct a VPGDB object, and then pass it to the VPG or EclipseVPG constructor.");
        }
        return this.vpg;
    }

    public void clear() {
        this.log.clear();
        this.notifyListeners();
    }

    public void clearEntriesFor(String filename) {
        LinkedList<Entry> newLog = new LinkedList<Entry>();
        for (Entry entry : this.log) {
            Object tokenRef = entry.getTokenRef();
            if (tokenRef != null && ((TokenRef)tokenRef).getFilename().equals(filename)) continue;
            newLog.add(entry);
        }
        this.log = newLog;
        this.notifyListeners();
    }

    public void logWarning(String message) {
        this.log.add(new Entry(this, true, message, null));
        this.notifyListeners();
    }

    public void logWarning(String message, String filename) {
        this.log.add(new Entry(this, true, message, this.getVPG().createTokenRef(filename, 0, 0)));
        this.notifyListeners();
    }

    public void logWarning(String message, R tokenRef) {
        this.log.add(new Entry(this, true, message, tokenRef));
        this.notifyListeners();
    }

    public void logError(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName());
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append("\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        this.log.add(new Entry(this, false, sb.toString(), null));
        this.notifyListeners();
    }

    public void logError(String message) {
        this.log.add(new Entry(this, false, message, null));
        this.notifyListeners();
    }

    public void logError(String message, R tokenRef) {
        this.log.add(new Entry(this, false, message, tokenRef));
        this.notifyListeners();
    }

    public boolean hasErrorsLogged() {
        for (Entry entry : this.log) {
            if (!entry.isError()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrorsOrWarningsLogged() {
        return !this.log.isEmpty();
    }

    public List<Entry> getEntries() {
        return this.log;
    }

    public void printOn(PrintStream out) {
        for (Entry entry : this.log) {
            out.print(entry.isError() ? "ERROR:   " : "Warning: ");
            out.println(entry.getMessage());
            Object t = entry.getTokenRef();
            if (t == null) continue;
            out.print("         (");
            out.print(((TokenRef)t).getFilename());
            out.print(", offset ");
            out.print(((TokenRef)t).getOffset());
            out.print(", length ");
            out.print(((TokenRef)t).getLength());
            out.println(")");
        }
    }

    public void addLogListener(ILogListener listener) {
        this.listeners.add(listener);
        listener.onLogChange();
    }

    public void removeLogListener(ILogListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ILogListener listener : this.listeners) {
            listener.onLogChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private boolean isWarning;
        private String message;
        private R tokenRef;
        final /* synthetic */ VPGLog this$0;

        public Entry(boolean isWarningOnly, String message, R tokenRef) {
            this.this$0 = var1_1;
            this.isWarning = isWarningOnly;
            this.message = message;
            this.tokenRef = tokenRef;
        }

        public boolean isWarning() {
            return this.isWarning;
        }

        public boolean isError() {
            return !this.isWarning;
        }

        public String getMessage() {
            return this.message;
        }

        public R getTokenRef() {
            return this.tokenRef;
        }
    }

    public static interface ILogListener {
        public void onLogChange();
    }
}

