/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rephraserengine.core.preservation.PreservationRule;
import org.eclipse.rephraserengine.core.vpg.TokenRef;
import org.eclipse.rephraserengine.core.vpg.VPG;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.core.preservation.Interval;
import org.eclipse.rephraserengine.internal.core.preservation.ModelDiff;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOp;
import org.eclipse.rephraserengine.internal.core.preservation.PrimitiveOpList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model {
    private String name;
    private EclipseVPG<?, ?, ?, ?, ?> vpg;
    private List<String> files;
    private Set<Entry> edges;

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<?, ?, ?, ?, ?> vpg, String ... filenames) {
        this(name, pm, ticks, vpg, Arrays.asList(filenames));
    }

    public Model(String name, IProgressMonitor pm, int ticks, EclipseVPG<?, ?, ?, ?, ?> vpg, List<String> filenames) {
        this.name = name;
        this.vpg = vpg;
        pm.subTask("Preparing to compute " + name);
        this.files = vpg.sortFilesAccordingToDependencies(new ArrayList<String>(filenames), (IProgressMonitor)new NullProgressMonitor());
        pm = new SubProgressMonitor(pm, ticks, 4);
        pm.beginTask("Computing " + name + ":", this.files.size());
        this.edges = new TreeSet<Entry>();
        for (String thisFile : this.files) {
            pm.subTask(VPG.lastSegmentOfFilename(thisFile));
            this.addEdges(thisFile, pm);
            pm.worked(1);
        }
        pm.done();
    }

    private void addEdges(String filename, IProgressMonitor pm) {
        for (VPGEdge edge : this.vpg.db.getAllEdgesFor(filename)) {
            Object source = edge.getSource();
            Object sink = edge.getSink();
            this.edges.add(new Entry(((TokenRef)source).getFilename(), new Interval(((TokenRef)source).getOffset(), ((TokenRef)source).getEndOffset()), ((TokenRef)sink).getFilename(), new Interval(((TokenRef)sink).getOffset(), ((TokenRef)sink).getEndOffset()), edge.getType()));
        }
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void inormalize(PrimitiveOpList primitiveOps, Set<PreservationRule> preserveEdgeTypes, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Normalizing " + this.name, this.edges.size());
        TreeSet<Entry> revisedList = new TreeSet<Entry>();
        for (Entry entry : this.edges) {
            for (PrimitiveOp op : primitiveOps) {
                if (!entry.shouldPreserveAccordingTo(preserveEdgeTypes, op.filename, op.iaff())) continue;
                entry.source = op.inorm(entry.sourceFilename, entry.source);
                entry.sink = op.inorm(entry.sinkFilename, entry.sink);
                for (PrimitiveOp otherOp : primitiveOps) {
                    if (otherOp.equals(op)) continue;
                    entry.offset(otherOp);
                }
                revisedList.add(entry);
                break;
            }
            pm.worked(1);
        }
        this.edges = revisedList;
        pm.done();
    }

    public void dnormalize(PrimitiveOpList primitiveOps, Set<PreservationRule> preserveEdgeTypes, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Normalizing " + this.name, this.edges.size());
        TreeSet<Entry> revisedList = new TreeSet<Entry>();
        for (Entry entry : this.edges) {
            for (PrimitiveOp op : primitiveOps) {
                Interval daff = this.offset(op.daff(), op, primitiveOps);
                if (!entry.shouldPreserveAccordingTo(preserveEdgeTypes, op.filename, daff)) continue;
                entry.source = op.dnorm(entry.sourceFilename, entry.source, daff);
                entry.sink = op.dnorm(entry.sinkFilename, entry.sink, daff);
                revisedList.add(entry);
                break;
            }
            pm.worked(1);
        }
        this.edges = revisedList;
        pm.done();
    }

    private Interval offset(Interval daff, PrimitiveOp op, PrimitiveOpList primitiveOps) {
        int dx = 0;
        int dy = 0;
        for (PrimitiveOp otherOp : primitiveOps) {
            if (otherOp.equals(op)) continue;
            dx += otherOp.offset(daff.lb) - daff.lb;
            dy += otherOp.offset(daff.ub) - daff.ub;
        }
        return new Interval(daff.lb + dx, daff.ub + dy);
    }

    public ModelDiff compareAgainst(Model that, IProgressMonitor pm) {
        pm = new SubProgressMonitor(pm, 0, 4);
        pm.beginTask("Differencing " + this.name + " and " + that.name, this.edges.size() + that.edges.size());
        ModelDiff diff = new ModelDiff();
        for (Entry entry : this.edges) {
            if (!that.edges.contains(entry)) {
                Entry otherEntry = this.findEntryWithNewSink(entry, that.edges);
                if (otherEntry != null) {
                    that.edges.remove(otherEntry);
                    diff.add(new ModelDiff.EdgeSinkChanged(entry.sourceFilename, entry.source, entry.sinkFilename, entry.sink, otherEntry.sinkFilename, otherEntry.sink, entry.edgeType));
                } else {
                    diff.add(new ModelDiff.EdgeDeleted(entry.sourceFilename, entry.origSource, entry.sinkFilename, entry.sink, entry.edgeType));
                }
            }
            pm.worked(1);
        }
        for (Entry entry : that.edges) {
            if (!this.edges.contains(entry)) {
                diff.add(new ModelDiff.EdgeAdded(entry.sourceFilename, entry.source, entry.sinkFilename, entry.sink, entry.edgeType));
            }
            pm.worked(1);
        }
        pm.done();
        return diff;
    }

    private Entry findEntryWithNewSink(Entry entry, Set<Entry> otherEdgeList) {
        for (Entry otherEntry : otherEdgeList) {
            if (!otherEntry.sourceFilename.equals(entry.sourceFilename) || !otherEntry.source.equals(entry.source) || otherEntry.edgeType != entry.edgeType) continue;
            return otherEntry;
        }
        return null;
    }

    public String toString() {
        return this.toString(null, null, null);
    }

    public String toString(String filename, CharSequence fileContents, ArrayList<Integer> lineMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.edges.size());
        sb.append(" edges\n\n");
        for (Entry entry : this.edges) {
            if (!entry.sourceFilename.equals(filename)) {
                sb.append(entry.sourceFilename);
                sb.append(':');
            }
            sb.append('[');
            sb.append(String.format("%5d", ((Entry)entry).source.lb));
            sb.append(", ");
            sb.append(String.format("%5d", ((Entry)entry).source.ub));
            sb.append(")  ===(");
            sb.append(entry.edgeType);
            sb.append(")==>  ");
            if (!entry.sinkFilename.equals(filename)) {
                sb.append(entry.sinkFilename);
                sb.append(':');
            }
            sb.append('[');
            sb.append(String.format("%5d", ((Entry)entry).sink.lb));
            sb.append(", ");
            sb.append(String.format("%5d", ((Entry)entry).sink.ub));
            sb.append(")");
            if (fileContents != null) {
                sb.append("           [");
                if (!entry.sourceFilename.equals(filename)) {
                    sb.append('?');
                } else if (((Entry)entry).source.lb >= 0 && ((Entry)entry).source.ub >= ((Entry)entry).source.lb) {
                    sb.append(fileContents.subSequence(((Entry)entry).source.lb, ((Entry)entry).source.ub));
                }
                sb.append("]");
                if (lineMap != null) {
                    sb.append(" (Line ");
                    sb.append(this.getLine(((Entry)entry).source.lb, lineMap));
                    sb.append(")");
                }
                sb.append("  ===(");
                sb.append(this.vpg.describeEdgeType(entry.edgeType));
                sb.append(")==>  [");
                if (!entry.sinkFilename.equals(filename)) {
                    sb.append('?');
                } else if (((Entry)entry).sink.lb >= 0 && ((Entry)entry).sink.ub >= ((Entry)entry).sink.lb) {
                    sb.append(fileContents.subSequence(((Entry)entry).sink.lb, ((Entry)entry).sink.ub));
                }
                sb.append("]");
                if (lineMap != null) {
                    sb.append(" (Line ");
                    sb.append(this.getLine(((Entry)entry).sink.lb, lineMap));
                    sb.append(")");
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private int getLine(int offset, ArrayList<Integer> lineMap) {
        int i = 0;
        while (i < lineMap.size()) {
            if (offset < lineMap.get(i)) {
                return i + 1;
            }
            ++i;
        }
        return lineMap.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry
    implements Comparable<Entry> {
        private String sourceFilename;
        private Interval source;
        private Interval origSource;
        private String sinkFilename;
        private Interval sink;
        private int edgeType;

        public Entry(String sourceFilename, Interval source, String sinkFilename, Interval sink, int edgeType) {
            if (source == null || sink == null) {
                throw new IllegalArgumentException();
            }
            this.sourceFilename = sourceFilename;
            this.source = this.origSource = source;
            this.sinkFilename = sinkFilename;
            this.sink = sink;
            this.edgeType = edgeType;
        }

        public boolean shouldPreserveAccordingTo(Set<PreservationRule> preserveEdgeTypes, String affectedFilename, Interval affected) {
            for (PreservationRule rule : preserveEdgeTypes) {
                if (!this.shouldPreserveAccordingTo(rule, affectedFilename, affected)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldPreserveAccordingTo(PreservationRule rule, String affectedFilename, Interval affected) {
            boolean incoming = this.sinkFilename.equals(affectedFilename) && this.sink.isSubsetOf(affected);
            boolean outgoing = this.sourceFilename.equals(affectedFilename) && this.source.isSubsetOf(affected);
            return rule.shouldPreserve(incoming, outgoing, this.edgeType);
        }

        public void offset(PrimitiveOp op) {
            this.source = op.inorm(this.sourceFilename, this.source);
            this.sink = op.inorm(this.sinkFilename, this.sink);
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            Entry that = (Entry)o;
            return this.sourceFilename.equals(that.sourceFilename) && this.source.equals(that.source) && this.sinkFilename.equals(that.sinkFilename) && this.sink.equals(that.sink) && this.edgeType == that.edgeType;
        }

        public int hashCode() {
            return 263 * this.source.hashCode() + 13 * this.sink.hashCode() + this.edgeType;
        }

        @Override
        public int compareTo(Entry that) {
            int result = this.sourceFilename.compareTo(that.sourceFilename);
            if (result == 0 && (result = this.sinkFilename.compareTo(that.sinkFilename)) == 0 && (result = this.source.compareTo(that.source)) == 0 && (result = this.sink.compareTo(that.sink)) == 0) {
                return that.edgeType - this.edgeType;
            }
            return result;
        }
    }
}

