/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.core.preservation.Interval;

public final class ModelDiff {
    private Set<DiffEntry> differences = new HashSet<DiffEntry>();

    void add(DiffEntry entry) {
        this.differences.add(entry);
    }

    public void processUsing(ModelDiffProcessor processor) {
        for (DiffEntry entry : this.differences) {
            entry.accept(processor);
        }
    }

    protected static abstract class DiffEntry {
        public final String sourceFilename;
        public final Interval source;
        public final String sinkFilename;
        public final Interval sink;
        public final int edgeType;

        public DiffEntry(String sourceFilename, Interval source, String sinkFilename, Interval sink, int edgeType) {
            this.sourceFilename = sourceFilename;
            this.source = source;
            this.sinkFilename = sinkFilename;
            this.sink = sink;
            this.edgeType = edgeType;
        }

        protected abstract void accept(ModelDiffProcessor var1);

        public IFile getFileContainingRegion() {
            return EclipseVPG.getIFileForFilename(this.sourceFilename);
        }

        public IRegion toRegion() {
            return new Region(this.source.lb, this.source.cardinality());
        }

        public boolean equals(Object other) {
            if (other == null || !other.getClass().equals(this.getClass())) {
                return false;
            }
            DiffEntry that = (DiffEntry)other;
            return this.sourceFilename.equals(that.sourceFilename) && this.source.equals(that.source) && this.sinkFilename.equals(that.sinkFilename) && this.sink.equals(that.sink) && this.edgeType == that.edgeType;
        }

        public int hashCode() {
            return this.getClass().hashCode() + 3 * this.sourceFilename.hashCode() + 5 * this.source.hashCode() + 7 * this.sinkFilename.hashCode() + 11 * this.sink.hashCode() + 13 * this.edgeType;
        }

        public String toString() {
            return String.valueOf(this.sourceFilename) + ":" + this.source + " -> " + this.sinkFilename + ":" + this.sink;
        }
    }

    public static final class EdgeAdded
    extends DiffEntry {
        public EdgeAdded(String sourceFilename, Interval source, String sinkFilename, Interval sink, int edgeType) {
            super(sourceFilename, source, sinkFilename, sink, edgeType);
        }

        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeAdded(this);
        }
    }

    public static final class EdgeDeleted
    extends DiffEntry {
        public EdgeDeleted(String sourceFilename, Interval source, String sinkFilename, Interval sink, int edgeType) {
            super(sourceFilename, source, sinkFilename, sink, edgeType);
        }

        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeDeleted(this);
        }
    }

    public static final class EdgeSinkChanged
    extends DiffEntry {
        public final String newSinkFilename;
        public final Interval newSink;

        public EdgeSinkChanged(String sourceFilename, Interval source, String sinkFilename, Interval sink, String newSinkFilename, Interval newSink, int edgeType) {
            super(sourceFilename, source, sinkFilename, sink, edgeType);
            this.newSinkFilename = newSinkFilename;
            this.newSink = newSink;
        }

        protected void accept(ModelDiffProcessor processor) {
            processor.processEdgeSinkChanged(this);
        }

        public String toString() {
            return String.valueOf(this.sourceFilename) + ":" + this.source + " -> " + this.sinkFilename + ":" + this.sink + " will become " + this.sourceFilename + ":" + this.source + " -> " + this.newSinkFilename + ":" + this.newSink;
        }

        public boolean equals(Object other) {
            return super.equals(other) && this.newSinkFilename.equals(((EdgeSinkChanged)other).newSinkFilename) && this.newSink.equals(((EdgeSinkChanged)other).newSink);
        }

        public int hashCode() {
            return super.hashCode() + 17 * this.newSinkFilename.hashCode() + 19 * this.newSink.hashCode();
        }
    }

    public static abstract class ModelDiffProcessor {
        public abstract void processEdgeAdded(EdgeAdded var1);

        public abstract void processEdgeDeleted(EdgeDeleted var1);

        public abstract void processEdgeSinkChanged(EdgeSinkChanged var1);
    }
}

