/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.core.preservation;

import org.eclipse.rephraserengine.internal.core.preservation.Interval;

public abstract class PrimitiveOp {
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public final String filename;

    public static Alpha alpha(String filename, Interval k) {
        return new Alpha(filename, k);
    }

    public static Alpha alpha(String filename, int k_lb, int k_ub) {
        return new Alpha(filename, new Interval(k_lb, k_ub));
    }

    public static Epsilon epsilon(String filename, Interval j) {
        return new Epsilon(filename, j);
    }

    public static Epsilon epsilon(String filename, int j_lb, int j_ub) {
        return new Epsilon(filename, new Interval(j_lb, j_ub));
    }

    public static Rho rho(String filename, Interval j, Interval k) {
        return new Rho(filename, j, k, null, null);
    }

    public static Rho rho(String filename, int j_lb, int j_ub, int k_lb, int k_ub) {
        return new Rho(filename, new Interval(j_lb, j_ub), new Interval(k_lb, k_ub), null, null);
    }

    public static Rho rho(String filename, int offset, int oldLength, int newLength) {
        return new Rho(filename, new Interval(offset, offset + oldLength), new Interval(offset, offset + newLength), null, null);
    }

    private PrimitiveOp(String filename) {
        this.filename = filename;
    }

    public abstract int offset(int var1);

    public abstract Interval inorm(String var1, Interval var2);

    public abstract Interval iaff();

    public abstract Interval dnorm(String var1, Interval var2);

    public abstract Interval dnorm(String var1, Interval var2, Interval var3);

    public abstract Interval daff();

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    /* synthetic */ PrimitiveOp(String string, PrimitiveOp primitiveOp) {
        this(string);
    }

    public static class Alpha
    extends Rho {
        private Alpha(String filename, Interval k) {
            super(filename, new Interval(k.lb, k.lb), k);
        }
    }

    public static class Epsilon
    extends Rho {
        private Epsilon(String filename, Interval j) {
            super(filename, j, new Interval(j.lb, j.lb));
        }
    }

    public static class Rho
    extends PrimitiveOp {
        public final Interval j;
        public final Interval k;

        private Rho(String filename, Interval j, Interval k) {
            super(filename, null);
            if (j.lb != k.lb) {
                throw new IllegalArgumentException("Rho-operation has mismatched lower bounds");
            }
            this.j = j;
            this.k = k;
        }

        public int offset(int n) {
            if (n < this.j.lb) {
                return n;
            }
            if (n >= this.j.ub) {
                return n - this.j.cardinality() + this.k.cardinality();
            }
            return Integer.MIN_VALUE;
        }

        public Interval inorm(String filename, Interval i) {
            if (!filename.equals(this.filename)) {
                return i;
            }
            return new Interval(this.offset(i.lb) != Integer.MIN_VALUE ? this.offset(i.lb) : this.k.lb, this.offset(i.ub) != Integer.MIN_VALUE ? this.offset(i.ub) : this.k.ub);
        }

        public Interval iaff() {
            return this.j;
        }

        public Interval dnorm(String filename, Interval i) {
            return this.dnorm(filename, i, this.k);
        }

        public Interval dnorm(String filename, Interval i, Interval k) {
            if (!filename.equals(this.filename)) {
                return i;
            }
            if (i.isSubsetOf(k)) {
                return k;
            }
            return i;
        }

        public Interval daff() {
            return this.k;
        }

        public String toString() {
            return String.valueOf(this.filename) + ":" + "rho<" + this.j + ", " + this.k + ">";
        }

        public int hashCode() {
            return 19 * this.j.hashCode() + this.k.hashCode();
        }

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass()) && this.j.equals(((Rho)o).j) && this.k.equals(((Rho)o).k);
        }

        /* synthetic */ Rho(String string, Interval interval, Interval interval2, Rho rho, Rho rho2) {
            this(string, interval, interval2);
        }
    }
}

