/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileStore;
import org.eclipse.ptp.remote.remotetools.core.RemoteToolsFileSystem;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

public class RemoteToolsFileManager
implements IRemoteFileManager {
    private String fWorkingDir = null;
    private final RemoteToolsConnection fConnection;

    public RemoteToolsFileManager(RemoteToolsConnection conn) {
        this.fConnection = conn;
    }

    public IFileStore getResource(String pathStr) {
        Path path = new Path(pathStr);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory()).append((IPath)path);
        }
        return new RemoteToolsFileStore(this.fConnection.getName(), path.toString());
    }

    public String getWorkingDirectory() {
        if (!this.fConnection.isOpen()) {
            return "/";
        }
        if (this.fWorkingDir == null) {
            IRemoteExecutionManager exeMgr = null;
            try {
                exeMgr = this.fConnection.createExecutionManager();
            }
            catch (RemoteConnectionException remoteConnectionException) {}
            if (exeMgr != null) {
                try {
                    this.fWorkingDir = exeMgr.getExecutionTools().executeWithOutput("pwd").trim();
                }
                catch (RemoteExecutionException remoteExecutionException) {
                }
                catch (RemoteConnectionException remoteConnectionException) {
                }
                catch (CancelException cancelException) {}
            }
            if (this.fWorkingDir == null) {
                return "/";
            }
        }
        return this.fWorkingDir;
    }

    public void setWorkingDirectory(String path) {
        if (new Path(path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return RemoteToolsFileSystem.getURIFor(this.fConnection.getName(), path.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI((IPath)new Path(path));
    }
}

