/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau.perfdmf.views;

import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.interfaces.EclipseHandler;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.etfw.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class PerfDMFView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action refreshAction;
    private Action doubleClickAction;
    private Action paraprofAction;
    private Action launchparaprofAction;
    private Action switchDatabaseAction;
    private String databaseName = null;

    static {
        ParaProf.insideEclipse = true;
    }

    IFile getFile(String filename, IResource[] resources) {
        try {
            int j = 0;
            while (j < resources.length) {
                IFile f;
                System.out.println("  considering resource '" + resources[j] + "'");
                if (resources[j] instanceof IFile) {
                    f = (IFile)resources[j];
                    System.out.println("filename = " + f.getName());
                    if (f.getName().equals(filename)) {
                        return f;
                    }
                } else if (resources[j] instanceof IFolder) {
                    System.out.println("recurse on Folder");
                    f = this.getFile(filename, ((IFolder)resources[j]).members());
                    if (f != null) {
                        return f;
                    }
                } else if (resources[j] instanceof IProject) {
                    System.out.println("recurse on Project");
                    f = this.getFile(filename, ((IProject)resources[j]).members());
                    if (f != null) {
                        return f;
                    }
                }
                ++j;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static String[] getDatabaseNames() {
        List dbs = Database.getDatabases();
        if (dbs.size() == 0) {
            return null;
        }
        String[] names = new String[dbs.size()];
        Iterator dit = dbs.iterator();
        int i = 0;
        while (dit.hasNext()) {
            Database dtest = (Database)dit.next();
            names[i] = String.valueOf(dtest.getConfig().getName()) + " - " + dtest.getConfig().getConnectionString();
            ++i;
        }
        return names;
    }

    public static String extractDatabaseName(String name) {
        List dbs = Database.getDatabases();
        if (dbs.size() == 0) {
            return null;
        }
        for (Database dtest : dbs) {
            if (!name.endsWith(String.valueOf(dtest.getConfig().getName()) + " - " + dtest.getConfig().getConnectionString())) continue;
            return dtest.getConfig().getName();
        }
        return null;
    }

    public Database getDatabase(String name) {
        List dbs = Database.getDatabases();
        if (dbs.size() < 1) {
            this.databaseName = null;
            return null;
        }
        if (name == null) {
            name = "Default";
        }
        for (Database dtest : dbs) {
            if (!dtest.getConfig().getName().equals(name)) continue;
            this.databaseName = name;
            if (this.switchDatabaseAction != null) {
                this.switchDatabaseAction.setText("Using Database: " + this.databaseName);
            }
            return dtest;
        }
        this.databaseName = ((Database)dbs.get(0)).getConfig().getName();
        if (this.switchDatabaseAction != null) {
            this.switchDatabaseAction.setText("Using Database: " + this.databaseName);
        }
        return (Database)dbs.get(0);
    }

    private void openSource(String projectName, SourceRegion sourceLink) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IFile file = this.getFile(sourceLink.getFilename(), root.members());
            if (file == null) {
                return;
            }
            FileEditorInput iEditorInput = new FileEditorInput(file);
            IWorkbenchPage p = PerfDMFView.getActivePage();
            String editorid = "org.eclipse.cdt.ui.editor.CEditor";
            if (file.getContentDescription().toString().indexOf("org.eclipse.photran.core.freeFormFortranSource") >= 0 || file.getContentDescription().toString().indexOf("org.eclipse.photran.core.fortranSource") >= 0) {
                editorid = "org.eclipse.photran.ui.FreeFormFortranEditor";
            } else if (file.getContentDescription().toString().indexOf("org.eclipse.photran.core.fixedFormFortranSource") >= 0) {
                editorid = "org.eclipse.photran.ui.FixedFormFortranEditor";
            }
            IEditorPart part = null;
            if (p != null) {
                part = p.openEditor((IEditorInput)iEditorInput, editorid, true);
            }
            TextEditor textEditor = (TextEditor)part;
            int start = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(sourceLink.getStartLine() - 1);
            int end = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()).getLineOffset(sourceLink.getEndLine());
            textEditor.setHighlightRange(start, end - start, true);
            TextEditor abstractTextEditor = textEditor;
            ISourceViewer viewer = null;
            Field[] fields = AbstractTextEditor.class.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                if ("fSourceViewer".equals(fields[i].getName())) {
                    Field f = fields[i];
                    f.setAccessible(true);
                    viewer = (ISourceViewer)f.get(abstractTextEditor);
                    break;
                }
                ++i;
            }
            if (viewer != null) {
                viewer.revealRange(start, end - start);
                viewer.setSelectedRange(start, end - start);
            }
        }
        catch (Throwable throwable) {}
    }

    public PerfDMFView() {
        PerfDMFUIPlugin.registerPerfDMFView(this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PerfDMFView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.paraprofAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.switchDatabaseAction);
        manager.add((IAction)this.launchparaprofAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private boolean openInParaProf(Trial trial) {
        Database database;
        DatabaseAPI dbApi;
        block3: {
            dbApi = new DatabaseAPI();
            database = this.getDatabase(this.databaseName);
            if (database != null) break block3;
            return false;
        }
        try {
            dbApi.initialize(database);
            dbApi.setTrial(trial.getID(), false);
            DBDataSource dbDataSource = new DBDataSource(dbApi);
            dbDataSource.load();
            trial.setDataSource((DataSource)dbDataSource);
            ParaProf.initialize();
            ParaProfTrial ppTrial = new ParaProfTrial(trial);
            ppTrial.getTrial().setDataSource((DataSource)dbDataSource);
            ppTrial.finishLoad();
            GlobalDataWindow gdw = new GlobalDataWindow(ppTrial, null);
            gdw.setVisible(true);
            dbApi.terminate();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return true;
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                ((ViewContentProvider)PerfDMFView.this.viewer.getContentProvider()).refresh((Viewer)PerfDMFView.this.viewer);
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh Data");
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/refresh.gif"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = PerfDMFView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeNode to = (TreeNode)obj;
                if (to.getUserObject() != null) {
                    PerfDMFView.this.openInParaProf((Trial)to.getUserObject());
                }
            }
        };
        this.switchDatabaseAction = new Action(){

            public void run() {
                ListDialog dblist = new ListDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                ArrayContentProvider dbs = new ArrayContentProvider();
                LabelProvider dl = new LabelProvider();
                String[] names = PerfDMFView.getDatabaseNames();
                dblist.setHelpAvailable(false);
                dblist.setContentProvider((IStructuredContentProvider)dbs);
                dblist.setLabelProvider((ILabelProvider)dl);
                dblist.setTitle("Select Database");
                dblist.setInput((Object)names);
                dblist.open();
                Object[] result = dblist.getResult();
                if (result != null && result.length >= 1) {
                    PerfDMFView.this.databaseName = PerfDMFView.extractDatabaseName(result[0].toString());
                    ((ViewContentProvider)PerfDMFView.this.viewer.getContentProvider()).refresh((Viewer)PerfDMFView.this.viewer);
                }
            }
        };
        this.switchDatabaseAction.setText("Using Database: " + this.databaseName);
        this.switchDatabaseAction.setToolTipText("Select another database");
        this.launchparaprofAction = new Action(){

            public void run() {
                ParaProf.initialize();
                ParaProf.paraProfManagerWindow.setVisible(true);
            }
        };
        this.launchparaprofAction.setText("Launch ParaProf");
        this.launchparaprofAction.setToolTipText("Launch ParaProf");
        this.launchparaprofAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/pp.gif"));
        this.paraprofAction = new Action(){

            public void run() {
                ISelection selection = PerfDMFView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TreeNode node = (TreeNode)obj;
                Trial trial = (Trial)node.getUserObject();
                PerfDMFView.this.openInParaProf(trial);
            }
        };
        this.paraprofAction.setText("Open in ParaProf");
        this.paraprofAction.setToolTipText("Open in ParaProf");
        this.paraprofAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"PDMA", (String)"icons/pp.gif"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PerfDMFView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public boolean showProfile(String project, String projectType, String trialName) {
        ViewContentProvider vcp = (ViewContentProvider)this.viewer.getContentProvider();
        vcp.refresh((Viewer)this.viewer);
        Object[] objs = vcp.getChildren(vcp.getRoot());
        int i = 0;
        while (i < objs.length) {
            TreeNode node = (TreeNode)objs[i];
            if (((Application)node.getUserObject()).getName().equals(project)) {
                this.viewer.setExpandedState((Object)node, true);
                TreeNode[] expObjs = node.getChildren();
                int j = 0;
                while (j < expObjs.length) {
                    TreeNode expNode = expObjs[j];
                    if (((Experiment)expNode.getUserObject()).getName().equals(projectType)) {
                        this.viewer.setExpandedState((Object)expNode, true);
                        TreeNode[] trialObjs = expNode.getChildren();
                        int k = 0;
                        while (k < trialObjs.length) {
                            TreeNode trialNode = trialObjs[k];
                            if (((Trial)trialNode.getUserObject()).getName().equals(trialName)) {
                                StructuredSelection selection = new StructuredSelection((Object)trialNode);
                                this.viewer.setSelection((ISelection)selection);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean addProfile(String project, String projectType, String trialName, String directory, String dbname) {
        Database database;
        DataSource dataSource;
        DatabaseAPI dbApi;
        block12: {
            dbApi = null;
            File[] dirs = new File[]{new File(directory)};
            if (System.getProperty("os.name").toLowerCase().trim().indexOf("aix") < 0) {
                System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            }
            dataSource = UtilFncs.initializeDataSource((File[])dirs, (int)1, (boolean)false);
            dbApi = new DatabaseAPI();
            database = this.getDatabase(dbname);
            if (database != null) break block12;
            return false;
        }
        try {
            this.databaseName = dbname;
            dbApi.initialize(database);
            Trial trial = new Trial();
            trial.setDataSource(dataSource);
            dataSource.load();
            trial.setMetaData(dataSource.getMetaData());
            trial.setName(trialName);
            Experiment exp = dbApi.getExperiment(project, projectType, true);
            trial.setExperimentID(exp.getID());
            dbApi.uploadTrial(trial);
            dbApi.terminate();
            ViewContentProvider vcp = (ViewContentProvider)this.viewer.getContentProvider();
            vcp.refresh((Viewer)this.viewer);
            Object[] objs = vcp.getChildren(vcp.getRoot());
            int i = 0;
            while (i < objs.length) {
                TreeNode node = (TreeNode)objs[i];
                if (((Application)node.getUserObject()).getID() == exp.getApplicationID()) {
                    this.viewer.setExpandedState((Object)node, true);
                    TreeNode[] expObjs = node.getChildren();
                    int j = 0;
                    while (j < expObjs.length) {
                        TreeNode expNode = expObjs[j];
                        if (((Experiment)expNode.getUserObject()).getID() == exp.getID()) {
                            this.viewer.setExpandedState((Object)expNode, true);
                            TreeNode[] trialObjs = expNode.getChildren();
                            int k = 0;
                            while (k < trialObjs.length) {
                                TreeNode trialNode = trialObjs[k];
                                if (((Trial)trialNode.getUserObject()).getID() == trial.getID()) {
                                    StructuredSelection selection = new StructuredSelection((Object)trialNode);
                                    this.viewer.setSelection((ISelection)selection);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            if (dbApi != null) {
                dbApi.terminate();
            }
            if (t instanceof DatabaseException) {
                ((DatabaseException)t).getException().printStackTrace();
            }
            t.printStackTrace();
            return false;
        }
        return true;
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class TreeNode
    implements IAdaptable {
        private String name;
        private Object userObject;
        private TreeNode parent;
        private ArrayList<TreeNode> children = new ArrayList();

        public TreeNode(String name, Object userObject) {
            this.name = name;
            this.userObject = userObject;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeNode child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeNode[] getChildren() {
            return this.children.toArray(new TreeNode[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeNode invisibleRoot;

        ViewContentProvider() {
        }

        public void refresh(Viewer v) {
            this.invisibleRoot = null;
            v.refresh();
        }

        public Object getRoot() {
            return this.invisibleRoot;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(PerfDMFView.this.getViewSite())) {
                if (this.invisibleRoot == null && !this.initialize()) {
                    return null;
                }
                return this.getChildren(this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            return ((TreeNode)child).getParent();
        }

        public Object[] getChildren(Object parent) {
            return ((TreeNode)parent).getChildren();
        }

        public boolean hasChildren(Object parent) {
            return ((TreeNode)parent).hasChildren();
        }

        private boolean initialize() {
            DatabaseAPI dbApi = null;
            try {
                ParaProf.eclipseHandler = new EclipseHandler(){

                    public boolean openSourceLocation(ParaProfTrial ppTrial, final Function function) {
                        System.out.println("Opening Source Code for " + function);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                PerfDMFView.this.openSource(null, function.getSourceLink());
                            }
                        });
                        return true;
                    }
                };
                this.invisibleRoot = new TreeNode("", null);
                dbApi = new DatabaseAPI();
                Database database = PerfDMFView.this.getDatabase(PerfDMFView.this.databaseName);
                if (database == null) {
                    this.invisibleRoot.addChild(new TreeNode("none", null));
                    return true;
                }
                try {
                    dbApi.initialize(database);
                    for (Application app : dbApi.getApplicationList()) {
                        dbApi.setApplication(app);
                        TreeNode root = new TreeNode(app.getName(), app);
                        for (Experiment exp : dbApi.getExperimentList()) {
                            dbApi.setExperiment(exp);
                            TreeNode tp = new TreeNode(exp.getName(), exp);
                            for (Trial trial : dbApi.getTrialList(false)) {
                                TreeNode to = new TreeNode(trial.getName(), trial);
                                tp.addChild(to);
                            }
                            root.addChild(tp);
                        }
                        this.invisibleRoot.addChild(root);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (dbApi != null) {
                    dbApi.db().close();
                    dbApi.terminate();
                }
            }
            return true;
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_FOLDER";
            if (((TreeNode)obj).getUserObject() instanceof Trial) {
                imageKey = "IMG_OBJ_ELEMENTS";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

