/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.util;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class Utility {
    public static Location getLocation(IASTNode node) {
        ASTNode astnode;
        ASTNode aSTNode = astnode = node instanceof ASTNode ? (ASTNode)node : null;
        if (astnode == null) {
            return null;
        }
        IASTFileLocation ifl = node.getFileLocation();
        int offset = 0;
        int length = 0;
        if (ifl != null) {
            offset = ifl.getNodeOffset();
            length = ifl.getNodeLength();
        } else {
            IASTNodeLocation[] locs = node.getNodeLocations();
            if (locs == null || locs.length == 0) {
                return null;
            }
            offset = locs[0].getNodeOffset();
            length = astnode.getLength();
        }
        return new Location(node, offset, offset + length - 1);
    }

    public static IDocument getDocument(String fullPathName) {
        IFile f;
        IResource r = ParserUtil.getResourceForFilename((String)fullPathName);
        IFile iFile = f = r instanceof IFile ? (IFile)r : null;
        if (f == null) {
            return null;
        }
        return Utility.getDocument(f);
    }

    public static IDocument getDocument(IFile file) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
        IDocument document = null;
        if (textFileBuffer != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    public static String getInputFile(ITextEditor editor) {
        IPath location;
        IPath location2;
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return null;
        }
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        if (file != null) {
            return file.getLocation().toOSString();
        }
        if (input instanceof IPathEditorInput && (location2 = ((IPathEditorInput)input).getPath()) != null) {
            return location2.toOSString();
        }
        ILocationProvider locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
        if (locationProvider != null && (location = locationProvider.getPath((Object)input)) != null) {
            return location.toOSString();
        }
        return null;
    }

    public static class Location {
        public IASTNode node_ = null;
        public int low_ = 0;
        public int high_ = 0;

        public Location(IASTNode node, int low, int high) {
            this.node_ = node;
            this.low_ = low;
            this.high_ = high;
        }

        public int getLow() {
            return this.low_;
        }

        public int getHigh() {
            return this.high_;
        }
    }
}

