/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.parser.ASTOperatorNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.AbstractFortranRefactoring;
import org.eclipse.photran.internal.core.refactoring.infrastructure.MultipleFileFortranRefactoring;

public class RepObsOpersRefactoring
extends MultipleFileFortranRefactoring {
    public String getName() {
        return "Replace Obsolete Operators";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws AbstractFortranRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws AbstractFortranRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = this.vpg.acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                }
                this.makeChangesTo(file, ast, status, pm);
                this.vpg.releaseAST(file);
            }
        }
        finally {
            this.vpg.releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws Error {
        try {
            if (ast == null) {
                return;
            }
            OperatorReplacingVisitor replacer = new OperatorReplacingVisitor();
            ast.accept(replacer);
            if (replacer.changedAST) {
                this.addChangeFromModifiedAST(file, pm);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private static final class OperatorReplacingVisitor
    extends Parser.GenericASTVisitor {
        private boolean changedAST = false;

        private OperatorReplacingVisitor() {
        }

        public void visitASTNode(Parser.IASTNode node) {
            if (node instanceof ASTOperatorNode) {
                this.replaceOperatorIn((ASTOperatorNode)node);
            }
            this.traverseChildren(node);
        }

        private void replaceOperatorIn(ASTOperatorNode op) {
            if (op.hasLtOp()) {
                this.setText(op, "<");
            }
            if (op.hasLeOp()) {
                this.setText(op, "<=");
            }
            if (op.hasEqOp()) {
                this.setText(op, "==");
            }
            if (op.hasNeOp()) {
                this.setText(op, "/=");
            }
            if (op.hasGtOp()) {
                this.setText(op, ">");
            }
            if (op.hasGeOp()) {
                this.setText(op, ">=");
            }
        }

        private void setText(ASTOperatorNode op, String newText) {
            op.findFirstToken().setText(newText);
            this.changedAST = true;
        }
    }
}

