/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.rdt.core.ILanguagePropertyProvider;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIndexerInfoProviderFactory {
    private static final String LANGUAGE_PROPERTIES_EXTENSION_ID = "languageProperties";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final int[] LINKAGE_IDS = new int[]{2, 1};
    private static final String[] INDEXER_PREFERENCE_KEYS = new String[]{"indexAllFiles", "skipReferences", "skipTypeReferences", "updatePolicy"};
    private static Map<String, List<ILanguagePropertyProvider>> languagePropertyProviderMap = new HashMap<String, List<ILanguagePropertyProvider>>();

    private static List<ILanguagePropertyProvider> getLanguagePropertyProviders(String languageId) {
        List<ILanguagePropertyProvider> providers = languagePropertyProviderMap.get(languageId);
        if (providers == null) {
            providers = new ArrayList<ILanguagePropertyProvider>();
            languagePropertyProviderMap.put(languageId, providers);
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.core", LANGUAGE_PROPERTIES_EXTENSION_ID);
            if (extensionPoint == null) {
                return providers;
            }
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement providerElement = iConfigurationElementArray[n4];
                    IConfigurationElement[] iConfigurationElementArray2 = providerElement.getChildren();
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement languageElement = iConfigurationElementArray2[n6];
                        String languageIdAttr = languageElement.getAttribute(ATTR_ID);
                        if (languageId.equals(languageIdAttr)) {
                            try {
                                providers.add((ILanguagePropertyProvider)providerElement.createExecutableExtension(ATTR_CLASS));
                            }
                            catch (CoreException e) {
                                RDTLog.logError(e);
                            }
                            break;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return providers;
    }

    public static Map<String, String> getLanguageProperties(String languageId, IProject project) {
        List<ILanguagePropertyProvider> providers = RemoteIndexerInfoProviderFactory.getLanguagePropertyProviders(languageId);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (ILanguagePropertyProvider provider : providers) {
            Map<String, String> languageProperties = provider.getProperties(languageId, project);
            if (languageProperties == null) continue;
            properties.putAll(languageProperties);
        }
        return properties;
    }

    public static RemoteIndexerInfoProvider getProvider(String scopeName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(scopeName);
        return RemoteIndexerInfoProviderFactory.getProvider(project);
    }

    public static RemoteIndexerInfoProvider getProvider(IProject project) {
        if (project == null) {
            return new RemoteIndexerInfoProvider();
        }
        final ArrayList<ICElement> elements = new ArrayList<ICElement>();
        IResourceVisitor resourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                ITranslationUnit tu = CoreModelUtil.findTranslationUnit((IFile)((IFile)resource));
                if (tu != null) {
                    elements.add(tu);
                }
                return true;
            }
        };
        try {
            project.accept(resourceVisitor);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
        }
        return RemoteIndexerInfoProviderFactory.getProvider(elements);
    }

    public static RemoteIndexerInfoProvider getProvider(List<ICElement> elements) {
        Object localScannerInfo;
        if (elements.isEmpty()) {
            return new RemoteIndexerInfoProvider();
        }
        HashMap<String, RemoteScannerInfo> scannerInfoMap = new HashMap<String, RemoteScannerInfo>();
        HashMap<Integer, RemoteScannerInfo> linkageMap = new HashMap<Integer, RemoteScannerInfo>();
        HashMap<String, String> languageMap = new HashMap<String, String>();
        HashSet<String> headerSet = new HashSet<String>();
        HashMap<String, Map<String, String>> languagePropertyMap = new HashMap<String, Map<String, String>>();
        IProject project = elements.get(0).getCProject().getProject();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        RemoteScannerInfoCache cache = new RemoteScannerInfoCache();
        for (ICElement element : elements) {
            if (!(element instanceof ITranslationUnit)) continue;
            ITranslationUnit tu = (ITranslationUnit)element;
            localScannerInfo = provider.getScannerInformation(tu.getResource());
            RemoteScannerInfo remoteScannerInfo = cache.get((IScannerInfo)localScannerInfo);
            String path = element.getLocationURI().getPath();
            scannerInfoMap.put(path, remoteScannerInfo);
            try {
                ILanguage language = tu.getLanguage();
                String id = language.getId();
                languageMap.put(path, id);
                if (!languagePropertyMap.containsKey(id)) {
                    languagePropertyMap.put(id, RemoteIndexerInfoProviderFactory.getLanguageProperties(id, project));
                }
            }
            catch (CoreException e) {
                RDTLog.logError(e);
            }
            if (!tu.isHeaderUnit()) continue;
            headerSet.add(path);
        }
        localScannerInfo = LINKAGE_IDS;
        int tu = LINKAGE_IDS.length;
        int n = 0;
        while (n < tu) {
            int id = localScannerInfo[n];
            IScannerInfo defaultScannerInfo = RemoteIndexerInfoProviderFactory.getDefaultScannerInfo(project, id);
            RemoteScannerInfo remoteScannerInfo = cache.get(defaultScannerInfo);
            linkageMap.put(id, remoteScannerInfo);
            ++n;
        }
        Properties props = IndexerPreferences.getProperties((IProject)project);
        Set<String> preferences = RemoteIndexerInfoProviderFactory.computeIndexerPreferences(props);
        String filePref = (String)props.get("filesToParseUpFront");
        List<String> filesToParseUpFront = Arrays.asList(filePref.split("\\s*,\\s*"));
        for (String filename : filesToParseUpFront) {
            IContentType ct = CCorePlugin.getContentType((IProject)project, (String)filename);
            if (ct == null) continue;
            ILanguage language = LanguageManager.getInstance().getLanguage(ct);
            languageMap.put(filename, language.getId());
        }
        return new RemoteIndexerInfoProvider(scannerInfoMap, linkageMap, languageMap, languagePropertyMap, headerSet, preferences, filesToParseUpFront);
    }

    private static Set<String> computeIndexerPreferences(Properties props) {
        HashSet<String> prefs = new HashSet<String>(props.size());
        String[] stringArray = INDEXER_PREFERENCE_KEYS;
        int n = INDEXER_PREFERENCE_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (Boolean.valueOf(props.getProperty(key)).booleanValue()) {
                prefs.add(key);
            }
            ++n2;
        }
        return prefs;
    }

    private static IScannerInfo getDefaultScannerInfo(IProject project, int linkageID) {
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider == null) {
            return null;
        }
        String filename = linkageID == 2 ? "__cdt__.c" : "__cdt__.cpp";
        IFile file = project.getFile(filename);
        IScannerInfo scanInfo = provider.getScannerInformation((IResource)file);
        if (scanInfo == null || scanInfo.getDefinedSymbols().isEmpty()) {
            scanInfo = provider.getScannerInformation((IResource)project);
            if (linkageID == 2) {
                Map definedSymbols = scanInfo.getDefinedSymbols();
                definedSymbols.remove("__cplusplus__");
                definedSymbols.remove("__cplusplus");
            }
        }
        return scanInfo;
    }

    public static RemoteScannerInfo getScannerInfo(IResource resource) {
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(resource.getProject());
        IScannerInfo scannerInfo = provider.getScannerInformation(resource);
        return new RemoteScannerInfo(scannerInfo);
    }

    private static class RemoteScannerInfoCache {
        Map<ScannerInfoKey, RemoteScannerInfo> cache = new HashMap<ScannerInfoKey, RemoteScannerInfo>();

        private RemoteScannerInfoCache() {
        }

        RemoteScannerInfo get(IScannerInfo localScannerInfo) {
            ScannerInfoKey key = new ScannerInfoKey(localScannerInfo);
            RemoteScannerInfo remoteScannerInfo = this.cache.get(key);
            if (remoteScannerInfo == null) {
                remoteScannerInfo = new RemoteScannerInfo(localScannerInfo);
                this.cache.put(key, remoteScannerInfo);
            }
            return remoteScannerInfo;
        }
    }

    private static class ScannerInfoKey {
        private IScannerInfo scannerInfo;
        private int hashCode = 0;

        ScannerInfoKey(IScannerInfo scannerInfo) {
            this.scannerInfo = scannerInfo;
        }

        public boolean equals(Object obj) {
            ScannerInfoKey other = (ScannerInfoKey)obj;
            return this.scannerInfo.getDefinedSymbols().equals(other.scannerInfo.getDefinedSymbols()) && Arrays.equals(this.scannerInfo.getIncludePaths(), other.scannerInfo.getIncludePaths());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.scannerInfo.getDefinedSymbols().hashCode() + Arrays.hashCode(this.scannerInfo.getIncludePaths());
            }
            return this.hashCode;
        }
    }
}

