/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.IOException;
import java.util.List;
import org.eclipse.cdt.internal.core.indexer.StandaloneFastIndexer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.ptp.internal.rdt.core.miners.CDTMiner;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteIndexProgressMonitor;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexerThread
extends Thread {
    private static final String LOG_TAG = "CDTMiner - IndexerThread";
    private final StandaloneFastIndexer indexer;
    private final DataElement status;
    private final CDTMiner miner;
    private IProgressMonitor progressMonitor;

    protected abstract void runIndexer(StandaloneFastIndexer var1, IProgressMonitor var2) throws IOException;

    private IndexerThread(StandaloneFastIndexer indexer, DataElement status, CDTMiner miner) {
        super("Remote Indexer");
        this.indexer = indexer;
        this.status = status;
        this.miner = miner;
    }

    public static IndexerThread createReindexThread(StandaloneFastIndexer indexer, final List<String> sourcesList, DataElement status, CDTMiner miner) {
        return new IndexerThread(indexer, status, miner){

            protected void runIndexer(StandaloneFastIndexer indexer, IProgressMonitor progressMonitor) throws IOException {
                indexer.rebuild(sourcesList, progressMonitor);
            }
        };
    }

    public static IndexerThread createIndexDeltaThread(StandaloneFastIndexer indexer, final List<String> added, final List<String> changed, final List<String> removed, DataElement status, CDTMiner miner) {
        return new IndexerThread(indexer, status, miner){

            protected void runIndexer(StandaloneFastIndexer indexer, IProgressMonitor progressMonitor) throws IOException {
                indexer.handleDelta(added, changed, removed, progressMonitor);
            }
        };
    }

    @Override
    public void run() {
        this.progressMonitor = new RemoteIndexProgressMonitor(this.indexer, this.status, this.miner._dataStore);
        try {
            this.indexer.setTraceStatistics(true);
            this.indexer.setShowProblems(true);
            this.indexer.setShowActivity(true);
            this.runIndexer(this.indexer, this.progressMonitor);
        }
        catch (IOException e) {
            UniversalServerUtilities.logError((String)LOG_TAG, (String)"I/O Exception while reindexing", (Throwable)e, (DataStore)this.miner._dataStore);
        }
        CDTMiner.statusDone(this.status);
    }

    public void cancel() {
        this.progressMonitor.setCanceled(true);
        UniversalServerUtilities.logDebugMessage((String)LOG_TAG, (String)"Indexer Thread Cancelled", (DataStore)this.miner._dataStore);
    }

    /* synthetic */ IndexerThread(StandaloneFastIndexer standaloneFastIndexer, DataElement dataElement, CDTMiner cDTMiner, IndexerThread indexerThread) {
        this(standaloneFastIndexer, dataElement, cDTMiner);
    }
}

