/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeManager {
    private Map<String, Set<String>> scopeNamesToFileSetMap = new TreeMap<String, Set<String>>();
    private static ScopeManager instance = null;

    private ScopeManager() {
    }

    public static synchronized ScopeManager getInstance() {
        if (instance == null) {
            instance = new ScopeManager();
        }
        return instance;
    }

    public void addScope(String name, Set<String> files) {
        this.scopeNamesToFileSetMap.put(name, files);
    }

    public void removeScope(String name) {
        this.scopeNamesToFileSetMap.remove(name);
    }

    public Set<String> getFilesForScope(String name) {
        return this.scopeNamesToFileSetMap.get(name);
    }

    public void addFileToScope(String scope, String filename) {
        Set<String> scopeFiles = this.getFilesForScope(scope);
        if (scopeFiles == null) {
            scopeFiles = new TreeSet<String>();
            this.scopeNamesToFileSetMap.put(scope, scopeFiles);
        }
        scopeFiles.add(filename);
    }

    public void removeFileFromScope(String scope, String filename) {
        Set<String> scopeFiles = this.getFilesForScope(scope);
        if (scopeFiles != null) {
            scopeFiles.remove(filename);
        }
    }

    public Set<String> getAllScopes() {
        return this.scopeNamesToFileSetMap.keySet();
    }

    public Set<String> getScopesForFile(String filename) {
        TreeSet<String> resultSet = new TreeSet<String>();
        IPath path = Path.fromOSString((String)filename);
        String canonicalPath = path.toOSString();
        if (canonicalPath.startsWith("//")) {
            canonicalPath = canonicalPath.substring(1);
        }
        Set<String> allScopes = this.getAllScopes();
        Set<String> scopeFiles = null;
        for (String scopeName : allScopes) {
            scopeFiles = this.getFilesForScope(scopeName);
            if (!scopeFiles.contains(canonicalPath)) continue;
            resultSet.add(scopeName);
        }
        return resultSet;
    }
}

