/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;

public class RemoteSearchTextSelectionQuery
extends RemoteSearchQuery {
    private static final long serialVersionUID = 1L;
    private ITranslationUnit tu;
    private String selection;
    private int offset;
    private int length;

    public RemoteSearchTextSelectionQuery(ICElement[] scope, ITranslationUnit tu, String selection, int offset, int length, int flags) {
        super(scope, flags | 8);
        this.tu = tu;
        this.selection = selection;
        this.offset = offset;
        this.length = length;
    }

    public IStatus runWithIndex(IIndex index, IIndexLocationConverter converter, IProgressMonitor monitor) {
        this.fConverter = converter;
        try {
            IASTName searchName;
            IASTTranslationUnit ast = this.tu.getAST(index, 2);
            if (ast != null && (searchName = ast.getNodeSelector(null).findEnclosingName(this.offset, this.length)) != null) {
                this.selection = searchName.toString();
                IBinding binding = searchName.resolveBinding();
                if (!(binding instanceof IProblemBinding)) {
                    if (binding != null) {
                        IScope scope = null;
                        try {
                            scope = binding.getScope();
                        }
                        catch (DOMException dOMException) {}
                        if (scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                            this.createLocalMatches(ast, binding);
                            return Status.OK_STATUS;
                        }
                    }
                    if ((binding = index.findBinding((IName)searchName)) != null) {
                        this.createMatches(index, binding);
                        return Status.OK_STATUS;
                    }
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public String getSelection() {
        return this.selection;
    }
}

