/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.attributes.ArrayAttributeDefinition;
import org.eclipse.ptp.core.attributes.BigIntegerAttributeDefinition;
import org.eclipse.ptp.core.attributes.BooleanAttributeDefinition;
import org.eclipse.ptp.core.attributes.DateAttributeDefinition;
import org.eclipse.ptp.core.attributes.DoubleAttributeDefinition;
import org.eclipse.ptp.core.attributes.EnumeratedAttributeDefinition;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringSetAttributeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDefinitionManager {
    private final Map<String, IAttributeDefinition<?, ?, ?>> attributeDefs = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeDefinition(IAttributeDefinition<?, ?, ?> attrDef) {
        Map<String, IAttributeDefinition<?, ?, ?>> map = this.attributeDefs;
        synchronized (map) {
            if (!this.attributeDefs.containsKey(attrDef.getId())) {
                this.attributeDefs.put(attrDef.getId(), attrDef);
            }
        }
    }

    public void setAttributeDefinitions(IAttributeDefinition<?, ?, ?>[] attrDefs) {
        IAttributeDefinition<?, ?, ?>[] iAttributeDefinitionArray = attrDefs;
        int n = attrDefs.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition<?, ?, ?> attrDef = iAttributeDefinitionArray[n2];
            this.setAttributeDefinition(attrDef);
            ++n2;
        }
    }

    public IAttributeDefinition<?, ?, ?> getAttributeDefinition(String attrId) {
        return this.attributeDefs.get(attrId);
    }

    public void clear() {
        this.attributeDefs.clear();
    }

    public BigIntegerAttributeDefinition createBigIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, BigInteger defaultValue) throws IllegalValueException {
        BigIntegerAttributeDefinition def = new BigIntegerAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public BigIntegerAttributeDefinition createBigIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, BigInteger defaultValue, BigInteger min, BigInteger max) throws IllegalValueException {
        BigIntegerAttributeDefinition def = new BigIntegerAttributeDefinition(uniqueId, name, description, display, defaultValue, min, max);
        this.setAttributeDefinition(def);
        return def;
    }

    public BooleanAttributeDefinition createBooleanAttributeDefinition(String uniqueId, String name, String description, boolean display, Boolean defaultValue) {
        BooleanAttributeDefinition def = new BooleanAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public DateAttributeDefinition createDateAttributeDefinition(String uniqueId, String name, String description, boolean display, Date defaultValue, DateFormat outputDateFormat) {
        DateAttributeDefinition def = new DateAttributeDefinition(uniqueId, name, description, display, defaultValue, outputDateFormat);
        this.setAttributeDefinition(def);
        return def;
    }

    public DateAttributeDefinition createDateAttributeDefinition(String uniqueId, String name, String description, boolean display, Date defaultValue, DateFormat outputDateFormat, Date min, Date max) throws IllegalValueException {
        DateAttributeDefinition def = new DateAttributeDefinition(uniqueId, name, description, display, defaultValue, outputDateFormat, min, max);
        this.setAttributeDefinition(def);
        return def;
    }

    public DoubleAttributeDefinition createDoubleAttributeDefinition(String uniqueId, String name, String description, boolean display, Double defaultValue) throws IllegalValueException {
        DoubleAttributeDefinition def = new DoubleAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public DoubleAttributeDefinition createDoubleAttributeDefinition(String uniqueId, String name, String description, boolean display, Double defaultValue, Double min, Double max) throws IllegalValueException {
        DoubleAttributeDefinition def = new DoubleAttributeDefinition(uniqueId, name, description, display, defaultValue, min, max);
        this.setAttributeDefinition(def);
        return def;
    }

    public <E extends Enum<E>> EnumeratedAttributeDefinition<E> createEnumeratedAttributeDefinition(String uniqueId, String name, String description, boolean display, E defaultValue) {
        EnumeratedAttributeDefinition<E> def = new EnumeratedAttributeDefinition<E>(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public IntegerAttributeDefinition createIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, Integer defaultValue) throws IllegalValueException {
        IntegerAttributeDefinition def = new IntegerAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public IntegerAttributeDefinition createIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, Integer defaultValue, Integer min, Integer max) throws IllegalValueException {
        IntegerAttributeDefinition def = new IntegerAttributeDefinition(uniqueId, name, description, display, defaultValue, min, max);
        this.setAttributeDefinition(def);
        return def;
    }

    public StringAttributeDefinition createStringAttributeDefinition(String uniqueId, String name, String description, boolean display, String defaultValue) {
        StringAttributeDefinition def = new StringAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public <T extends Comparable<T>> ArrayAttributeDefinition<T> createArrayAttributeDefinition(String uniqueId, String name, String description, boolean display, T[] defaultValue) {
        ArrayAttributeDefinition def = new ArrayAttributeDefinition(uniqueId, name, description, display, defaultValue);
        this.setAttributeDefinition(def);
        return def;
    }

    public StringSetAttributeDefinition createStringSetAttributeDefinition(String uniqueId, String name, String description, boolean display, String defaultValue, String[] values) throws IllegalValueException {
        return new StringSetAttributeDefinition(uniqueId, name, description, display, defaultValue, values);
    }
}

