/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.core.PreferenceConstants;

public class OutputTextFile
implements PreferenceConstants {
    private String filename = "";
    private File file = null;
    private String outputPath = null;
    private int storeLine = 0;
    private int lineCounter = 0;

    public OutputTextFile(String name, String type, String outputPath, int storeLine) {
        this.filename = String.valueOf(name) + "." + type;
        this.outputPath = outputPath;
        this.storeLine = storeLine;
        this.init();
    }

    private void init() {
        this.file = this.getFilePath();
    }

    private File getFilePath() {
        IPath filePath = new Path(this.outputPath).append(this.filename);
        File tmpFile = filePath.toFile();
        try {
            tmpFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println("OutputTextFile - getFilePath err: " + e.getMessage());
        }
        return tmpFile;
    }

    public void write(String text) {
        if (this.lineCounter == this.storeLine) {
            this.lineCounter = 0;
            this.write(text, false);
        } else {
            this.write(text, true);
        }
    }

    public void write(String text, boolean isAppend) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.file, isAppend);
                fos.write(text.getBytes());
                ++this.lineCounter;
            }
            catch (FileNotFoundException e) {
                System.out.println("OutputTextFile - append file err: " + e.getMessage());
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("OutputTextFile - append close err: " + ioe.getMessage());
                    }
                }
                fos = null;
            }
            catch (IOException ioe) {
                block18: {
                    System.out.println("OutputTextFile - append io err: " + ioe.getMessage());
                    if (fos == null) break block18;
                    try {
                        fos.close();
                    }
                    catch (IOException ioe2) {
                        System.out.println("OutputTextFile - append close err: " + ioe2.getMessage());
                    }
                }
                fos = null;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    System.out.println("OutputTextFile - append close err: " + ioe.getMessage());
                }
            }
            fos = null;
        }
    }

    public void delete() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
        this.file = null;
    }

    public String getContents() {
        if (this.file == null) {
            return null;
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(this.file));
            String string = this.readString(is, ResourcesPlugin.getEncoding());
            return string;
        }
        catch (FileNotFoundException e) {
            System.out.println("OutputTextFile - read file err: " + e.getMessage());
        }
        finally {
            is = null;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }
}

