/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;

class ExecutionObserver
extends Job {
    private Connection fConnection;

    public ExecutionObserver(Connection connection) {
        super(Messages.ExecutionObserver_ExecutionObserver_RemoteCommandObserver);
        this.fConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (!monitor.isCanceled()) {
            Connection connection;
            KillableExecution finished = null;
            if (this.fConnection.isConnected() && this.fConnection.getActiveProcessTable() != null) {
                connection = this.fConnection;
                synchronized (connection) {
                    for (Map.Entry<Integer, KillableExecution> entry : this.fConnection.getActiveProcessTable().entrySet()) {
                        if (entry.getValue().isRunning()) continue;
                        finished = entry.getValue();
                        break;
                    }
                }
            }
            if (finished != null) {
                finished.notifyFinish();
                finished = null;
                continue;
            }
            connection = this.fConnection;
            synchronized (connection) {
                try {
                    this.fConnection.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return Status.OK_STATUS;
    }
}

