/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.JSchException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.RemotePortForwarding;

public class RemotePortForwardingPool {
    HashMap<Integer, RemotePortForwarding> remotePortForwardings = new HashMap();
    Connection connection;

    RemotePortForwardingPool(Connection connection) {
        assert (connection != null);
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemotePortForwarding createRemotePortForwarding(ExecutionManager owner, int remotePort, String localAddress, int localPort) throws RemoteConnectionException, PortForwardingException {
        assert (remotePort > 0);
        assert (localPort > 0);
        assert (owner != null);
        assert (this.connection.defaultSession != null);
        HashMap<Integer, RemotePortForwarding> hashMap = this.remotePortForwardings;
        synchronized (hashMap) {
            Integer remotePortInteger = new Integer(remotePort);
            RemotePortForwarding remotePortForwarding = this.remotePortForwardings.get(remotePortInteger);
            if (remotePortForwarding != null) {
                throw new PortForwardingException(1);
            }
            try {
                this.connection.defaultSession.setPortForwardingR(remotePort, localAddress, localPort);
            }
            catch (JSchException e) {
                throw new PortForwardingException(2, (Throwable)e);
            }
            remotePortForwarding = new RemotePortForwarding(owner, localPort, localAddress, remotePort);
            this.remotePortForwardings.put(remotePortInteger, remotePortForwarding);
            return remotePortForwarding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRemotePortForwarding(RemotePortForwarding remoteForwarding, ExecutionManager owner) throws RemoteConnectionException, PortForwardingException {
        assert (remoteForwarding != null);
        assert (this.connection.defaultSession != null);
        HashMap<Integer, RemotePortForwarding> hashMap = this.remotePortForwardings;
        synchronized (hashMap) {
            if (!remoteForwarding.isActive()) {
                throw new PortForwardingException(4);
            }
            if (owner != null && remoteForwarding.owner != owner) {
                throw new PortForwardingException(4);
            }
            Integer remotePortInteger = new Integer(remoteForwarding.remotePort);
            assert (this.remotePortForwardings.containsKey(remotePortInteger));
            this.turnOffRemotePortForwarding(remoteForwarding);
            this.remotePortForwardings.remove(remotePortInteger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemotePortForwarding getRemotePortForwarding(int remotePort) throws RemoteConnectionException, PortForwardingException {
        assert (remotePort > 0);
        assert (this.connection.defaultSession != null);
        HashMap<Integer, RemotePortForwarding> hashMap = this.remotePortForwardings;
        synchronized (hashMap) {
            Integer remotePortInteger = new Integer(remotePort);
            return this.remotePortForwardings.get(remotePortInteger);
        }
    }

    void disconnect() {
        Iterator<RemotePortForwarding> iterator = this.remotePortForwardings.values().iterator();
        while (iterator.hasNext()) {
            RemotePortForwarding forwarding = iterator.next();
            this.turnOffRemotePortForwarding(forwarding);
            iterator.remove();
        }
    }

    void disconnect(ExecutionManager executionManager) {
        Iterator<RemotePortForwarding> iterator = this.remotePortForwardings.values().iterator();
        while (iterator.hasNext()) {
            RemotePortForwarding forwarding = iterator.next();
            if (forwarding.owner != executionManager) continue;
            this.turnOffRemotePortForwarding(forwarding);
            iterator.remove();
        }
    }

    private void turnOffRemotePortForwarding(RemotePortForwarding forwarding) {
        block2: {
            forwarding.releaseOwner();
            try {
                this.connection.defaultSession.delPortForwardingR(forwarding.remotePort);
            }
            catch (JSchException jSchException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

