/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.remotetools.environment.generichost.Activator;
import org.eclipse.ptp.remotetools.environment.generichost.conf.AttributeNames;
import org.eclipse.ptp.remotetools.environment.generichost.conf.DefaultValues;
import org.eclipse.ptp.remotetools.environment.generichost.core.TargetConfig;
import org.eclipse.ptp.remotetools.environment.generichost.core.TargetControl;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public class ConfigFactory {
    Map currentMap = null;
    Map defaultMap = null;
    ControlAttributes attributes = null;
    private static final String PREFIX = "org.eclipse.ptp.remotetools.environment.generichost..";
    public static final String ATTR_LOCALHOST_SELECTION = "org.eclipse.ptp.remotetools.environment.generichost..localhost-selection";
    public static final String ATTR_LOGIN_USERNAME = "org.eclipse.ptp.remotetools.environment.generichost..login-username";
    public static final String ATTR_LOGIN_PASSWORD = "org.eclipse.ptp.remotetools.environment.generichost..login-password";
    public static final String ATTR_CONNECTION_ADDRESS = "org.eclipse.ptp.remotetools.environment.generichost..connection-address";
    public static final String ATTR_CONNECTION_PORT = "org.eclipse.ptp.remotetools.environment.generichost..connection-port";
    public static final String ATTR_KEY_PATH = "org.eclipse.ptp.remotetools.environment.generichost..key-path";
    public static final String ATTR_KEY_PASSPHRASE = "org.eclipse.ptp.remotetools.environment.generichost..key-passphrase";
    public static final String ATTR_IS_PASSWORD_AUTH = "org.eclipse.ptp.remotetools.environment.generichost..is-passwd-auth";
    public static final String ATTR_CONNECTION_TIMEOUT = "org.eclipse.ptp.remotetools.environment.generichost..connection-timeout";
    public static final String ATTR_SYSTEM_WORKSPACE = "org.eclipse.ptp.remotetools.environment.generichost..system-workspace-dir";
    public static final String ATTR_CIPHER_TYPE = "org.eclipse.ptp.remotetools.environment.generichost..cipher-type";
    public static final String[] KEY_ARRAY = new String[]{"org.eclipse.ptp.remotetools.environment.generichost..localhost-selection", "org.eclipse.ptp.remotetools.environment.generichost..login-username", "org.eclipse.ptp.remotetools.environment.generichost..connection-port", "org.eclipse.ptp.remotetools.environment.generichost..connection-address", "org.eclipse.ptp.remotetools.environment.generichost..key-path", "org.eclipse.ptp.remotetools.environment.generichost..is-passwd-auth", "org.eclipse.ptp.remotetools.environment.generichost..connection-timeout", "org.eclipse.ptp.remotetools.environment.generichost..system-workspace-dir", "org.eclipse.ptp.remotetools.environment.generichost..cipher-type"};
    public static final String[] KEY_CIPHERED_ARRAY = new String[]{"org.eclipse.ptp.remotetools.environment.generichost..key-passphrase", "org.eclipse.ptp.remotetools.environment.generichost..login-password"};

    public ConfigFactory() {
        this.createDefaultMap();
        this.createCurrentMapFromPreferences();
        this.attributes = new ControlAttributes(this.currentMap, this.defaultMap);
    }

    public ConfigFactory(Map newMap) {
        this.createDefaultMap();
        if (newMap == null) {
            this.createCurrentMapFromPreferences();
        } else {
            this.currentMap = new HashMap(newMap);
        }
        this.attributes = new ControlAttributes(this.currentMap, this.defaultMap);
    }

    public Map getMap() {
        return this.currentMap;
    }

    public ControlAttributes getAttributes() {
        return this.attributes;
    }

    private void createDefaultMap() {
        this.defaultMap = new HashMap();
        this.defaultMap.put(ATTR_LOCALHOST_SELECTION, DefaultValues.LOCALHOST_SELECTION);
        this.defaultMap.put(ATTR_LOGIN_USERNAME, DefaultValues.LOGIN_USERNAME);
        this.defaultMap.put(ATTR_LOGIN_PASSWORD, DefaultValues.LOGIN_PASSWORD);
        this.defaultMap.put(ATTR_CONNECTION_PORT, DefaultValues.CONNECTION_PORT);
        this.defaultMap.put(ATTR_CONNECTION_ADDRESS, DefaultValues.CONNECTION_ADDRESS);
        this.defaultMap.put(ATTR_KEY_PATH, DefaultValues.KEY_PATH);
        this.defaultMap.put(ATTR_KEY_PASSPHRASE, DefaultValues.KEY_PASSPHRASE);
        this.defaultMap.put(ATTR_IS_PASSWORD_AUTH, DefaultValues.IS_PASSWORD_AUTH);
        this.defaultMap.put(ATTR_CONNECTION_TIMEOUT, DefaultValues.CONNECTION_TIMEOUT);
        this.defaultMap.put(ATTR_SYSTEM_WORKSPACE, DefaultValues.SYSTEM_WORKSPACE);
        this.defaultMap.put(ATTR_CIPHER_TYPE, TargetControl.DEFAULT_CIPHER);
    }

    private void createCurrentMapFromPreferences() {
        this.currentMap = new HashMap();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.currentMap.put(ATTR_LOGIN_USERNAME, store.getString(ATTR_LOGIN_USERNAME));
        this.currentMap.put(ATTR_CONNECTION_ADDRESS, store.getString(ATTR_CONNECTION_ADDRESS));
        this.currentMap.put(ATTR_CONNECTION_PORT, store.getString(ATTR_CONNECTION_PORT));
        this.currentMap.put(ATTR_SYSTEM_WORKSPACE, store.getString(ATTR_SYSTEM_WORKSPACE));
    }

    public TargetConfig createTargetConfig() throws CoreException {
        try {
            TargetConfig config = new TargetConfig();
            config.setLoginUserName(this.attributes.getString(ATTR_LOGIN_USERNAME));
            config.setLoginPassword(this.attributes.getString(ATTR_LOGIN_PASSWORD));
            config.setConnectionPort(this.attributes.verifyInt(AttributeNames.CONNECTION_PORT, ATTR_CONNECTION_PORT));
            if (this.attributes.getBoolean(ATTR_LOCALHOST_SELECTION)) {
                config.setConnectionAddress("localhost");
            } else {
                config.setConnectionAddress(this.attributes.getString(ATTR_CONNECTION_ADDRESS));
            }
            config.setConnectionTimeout(this.attributes.verifyInt(AttributeNames.CONNECTION_TIMEOUT, ATTR_CONNECTION_TIMEOUT));
            config.setKeyPassphrase(this.attributes.getString(ATTR_KEY_PASSPHRASE));
            config.setKeyPath(this.attributes.getString(ATTR_KEY_PATH));
            config.setIsPasswordAuth(this.attributes.getBoolean(ATTR_IS_PASSWORD_AUTH));
            config.setSystemWorkspace(this.attributes.getString(ATTR_SYSTEM_WORKSPACE));
            config.setCipherType(this.attributes.getString(ATTR_CIPHER_TYPE));
            return config;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }
}

