/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.variable;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableMessages;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableView;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.debug.ui.PVariableManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PVariableDialog
extends Dialog {
    public static final int NEW_MODE = 0;
    public static final int EDIT_MODE = 1;
    protected Text varText = null;
    protected Table varTable = null;
    protected Button checkBtn = null;
    protected PVariableView view = null;
    protected int mode = 0;

    public PVariableDialog(PVariableView view) {
        this(view, 0);
    }

    public PVariableDialog(PVariableView view, int mode) {
        super(view.getSite().getShell());
        this.view = view;
        this.mode = mode;
    }

    public void configureShell(Shell newShell) {
        newShell.setText(PVariableMessages.getString("PVariablesDialog.title"));
        super.configureShell(newShell);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    private void createOthersSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 25;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.checkBtn = new Button(comp, 32);
        this.checkBtn.setText(PVariableMessages.getString("PVariablesDialog.checkBtn"));
        this.checkBtn.setSelection(true);
    }

    private void createVarSection(Composite parent) {
        Group aGroup = new Group(parent, 2048);
        aGroup.setText(PVariableMessages.getString("PVariablesDialog.varSection"));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        aGroup.setLayout((Layout)layout);
        aGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Label availLabel = new Label((Composite)aGroup, 0);
        availLabel.setText(PVariableMessages.getString("PVariablesDialog.availVar"));
        availLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.varTable = new Table((Composite)aGroup, 68388);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        gd.heightHint = 150;
        this.varTable.setLayoutData((Object)gd);
        this.varTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                boolean checked = item.getChecked();
                if (checked) {
                    PVariableDialog.this.varText.setText("");
                }
                PVariableDialog.this.updateButtons();
                item.setChecked(checked);
            }
        });
        Label custLabel = new Label((Composite)aGroup, 0);
        custLabel.setText(PVariableMessages.getString("PVariablesDialog.custVar"));
        custLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.varText = new Text((Composite)aGroup, 2048);
        this.varText.setLayoutData((Object)new GridData(768));
        this.varText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (PVariableDialog.this.varText.getText().length() > 0) {
                    TableItem[] items = PVariableDialog.this.varTable.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
                PVariableDialog.this.updateButtons();
            }
        });
        this.varText.setFocus();
    }

    private boolean anyTableItemChecked(Table table) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateButtons() {
        boolean enabled = true;
        if (this.getSelectedVariables().length == 0) {
            enabled = false;
        }
        this.getOkButton().setEnabled(enabled);
    }

    protected void initContent() {
        ISelection selection;
        PVariableManager.PVariableInfo jVar = null;
        if (this.mode == 1 && !(selection = this.view.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            jVar = (PVariableManager.PVariableInfo)((IStructuredSelection)selection).getFirstElement();
            this.varText.setText(jVar.getName());
            this.checkBtn.setSelection(jVar.isEnabled());
        }
        TableItem item = null;
        String[] stringArray = this.getAvailableVariables();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            item = new TableItem(this.varTable, 0);
            item.setText(var);
            if (jVar != null) {
                item.setChecked(jVar.getName().equals(var));
            }
            ++n2;
        }
    }

    protected String[] getAvailableVariables() {
        ISelection selection = this.view.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection.isEmpty()) {
            return new String[0];
        }
        if (selection instanceof IStructuredSelection) {
            Object target = ((IStructuredSelection)selection).getFirstElement();
            try {
                IThread[] threads;
                if (target instanceof IStackFrame) {
                    return this.getVariables((IStackFrame)target);
                }
                if (target instanceof IThread) {
                    return this.getVariables(((IThread)target).getTopStackFrame());
                }
                if (target instanceof IPDebugTarget && (threads = ((IPDebugTarget)target).getThreads()).length > 0) {
                    return this.getVariables(threads[0].getTopStackFrame());
                }
            }
            catch (DebugException debugException) {
                return new String[0];
            }
        }
        return new String[0];
    }

    private String[] getVariables(IStackFrame frame) throws DebugException {
        if (frame == null) {
            return new String[0];
        }
        IVariable[] vars = frame.getVariables();
        String[] varTexts = new String[vars.length];
        int j = 0;
        while (j < vars.length) {
            varTexts[j] = vars[j].getName();
            ++j;
        }
        return varTexts;
    }

    protected void createVerticalSpan(Composite parent, int space) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(1808);
        gd.verticalSpan = space;
        label.setLayoutData((Object)gd);
    }

    public Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        switch (this.mode) {
            case 0: {
                this.getOkButton().setText("Create");
                break;
            }
            case 1: {
                this.getOkButton().setText("Edit");
            }
        }
        this.updateButtons();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createVarSection(composite);
        this.createVerticalSpan(composite, 2);
        this.createOthersSection(composite);
        this.initContent();
        return composite;
    }

    protected String[] getSelectedVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        TableItem[] items = this.varTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                vars.add(items[i].getText());
                items[i].setChecked(this.mode == 0);
            }
            ++i;
        }
        if (vars.size() == 0 && this.varText.getText().length() > 0) {
            vars.add(this.varText.getText());
        }
        return vars.toArray(new String[0]);
    }

    protected void okPressed() {
        PVariableManager jobMgr = this.view.getUIManager().getJobVariableManager();
        IPJob job = this.view.getUIManager().getJob();
        String[] vars = this.getSelectedVariables();
        boolean checked = this.checkBtn.getSelection();
        switch (this.mode) {
            case 0: {
                int i = 0;
                while (i < vars.length) {
                    try {
                        jobMgr.addVariable(job, vars[i], checked);
                    }
                    catch (CoreException e) {
                        PTPDebugUIPlugin.errorDialog("Duplicate variable", e.getStatus());
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                ISelection selection = this.view.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) break;
                PVariableManager.PVariableInfo jVar = (PVariableManager.PVariableInfo)((IStructuredSelection)selection).getFirstElement();
                String[] stringArray = vars;
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    String var = stringArray[n2];
                    String newvar = jVar.getName().equals(var) ? null : var;
                    try {
                        jobMgr.updateVariable(job, jVar.getName(), newvar, checked);
                    }
                    catch (CoreException coreException) {}
                    ++n2;
                }
                break;
            }
        }
        super.okPressed();
    }
}

