/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.dialogs.DeferredFileStore;
import org.eclipse.ptp.remote.ui.dialogs.RemoteContentProvider;
import org.eclipse.ptp.remote.ui.dialogs.RemoteResourceComparator;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RemoteResourceBrowser
extends Dialog {
    public static final String EMPTY_STRING = "";
    public static final int FILE_BROWSER = 1;
    public static final int DIRECTORY_BROWSER = 2;
    public static final int SINGLE = 1;
    public static final int MULTI = 2;
    private static final int widthHint = 300;
    private static final int heightHint = 300;
    private Tree tree = null;
    private TreeViewer treeViewer = null;
    private Text remotePathText = null;
    private Button okButton = null;
    private Combo connectionCombo = null;
    private Button newButton = null;
    private int browserType;
    private String dialogTitle;
    private String dialogLabel;
    private boolean showConnections = false;
    private String remotePath = "";
    private String[] remotePaths;
    private String initialPath = null;
    private IRemoteServices services = null;
    private IRemoteFileManager fileMgr = null;
    private IRemoteConnection connection = null;
    private IRemoteConnectionManager connMgr = null;
    private IRemoteUIConnectionManager uiConnMgr = null;
    private int optionFlags = 1;

    public RemoteResourceBrowser(IRemoteServices services, IRemoteConnection conn, Shell parent, int flags) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.services = services;
        this.connection = conn;
        this.optionFlags = flags;
        if (conn == null) {
            this.showConnections = true;
        }
        this.connMgr = services.getConnectionManager();
        this.uiConnMgr = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(services).getUIConnectionManager();
        this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        this.setType(3);
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public String getPath() {
        if (this.remotePath.equals(EMPTY_STRING)) {
            return null;
        }
        return this.remotePath;
    }

    public String[] getPaths() {
        return this.remotePaths;
    }

    public void setInitialPath(String path) {
        this.initialPath = path;
    }

    public void setTitle(String title) {
        Shell shell;
        this.dialogTitle = title;
        if (this.dialogTitle == null) {
            this.dialogTitle = EMPTY_STRING;
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setText(this.dialogTitle);
        }
    }

    public void setType(int type) {
        this.browserType = type;
        if (type == 1) {
            this.dialogLabel = Messages.RemoteResourceBrowser_fileLabel;
            this.setTitle(Messages.RemoteResourceBrowser_fileTitle);
        } else if (type == 2) {
            this.dialogLabel = Messages.RemoteResourceBrowser_directoryLabel;
            this.setTitle(Messages.RemoteResourceBrowser_directoryTitle);
        } else {
            this.dialogLabel = Messages.RemoteResourceBrowser_resourceLabel;
            this.setTitle(Messages.RemoteResourceBrowser_resourceTitle);
        }
    }

    public void showConnections(boolean enable) {
        this.showConnections = enable;
    }

    private boolean changeInput(final IRemoteConnection conn) {
        if (conn == null) {
            return false;
        }
        if (!conn.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        conn.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        ErrorDialog.openError((Shell)RemoteResourceBrowser.this.getShell(), (String)Messages.RemoteResourceBrowser_1, (String)Messages.RemoteResourceBrowser_2, (IStatus)new Status(4, "org.eclipse.ptp.remote.ui", e.getMessage()));
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RemoteResourceBrowser_1, (String)Messages.RemoteResourceBrowser_2, (IStatus)new Status(4, "org.eclipse.ptp.remote.ui", e.getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RemoteResourceBrowser_1, (String)Messages.RemoteResourceBrowser_2, (IStatus)new Status(4, "org.eclipse.ptp.remote.ui", e.getMessage()));
            }
        }
        this.fileMgr = this.services.getFileManager(conn);
        if (this.fileMgr != null) {
            String cwd = this.fileMgr.getWorkingDirectory();
            IPath initial = this.findInitialPath(cwd, this.initialPath);
            this.remotePathText.setText(initial.toString());
            IFileStore root = this.fileMgr.getResource(cwd);
            this.treeViewer.setInput((Object)new DeferredFileStore(root));
            this.connection = conn;
            return true;
        }
        return false;
    }

    private void connectionSelected() {
        IRemoteConnection conn;
        int i = this.connectionCombo.getSelectionIndex();
        if (i >= 0 && !this.changeInput(conn = this.connMgr.getConnection(this.connectionCombo.getItem(i)))) {
            if (this.connection == null) {
                this.connectionCombo.deselectAll();
            } else {
                i = 0;
                while (i < this.connectionCombo.getItemCount()) {
                    if (this.connection.equals(this.connectionCombo.getItem(i))) {
                        this.connectionCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void createConnectionChooser(Composite comp) {
        Composite connComp = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        connComp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        connComp.setLayoutData((Object)gd);
        Label label = new Label(connComp, 0);
        label.setText(Messages.RemoteResourceBrowser_connectonLabel);
        gd = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(connComp, 8);
        gd = new GridData(4, 0x1000000, true, false);
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() == RemoteResourceBrowser.this.connectionCombo) {
                    RemoteResourceBrowser.this.connectionSelected();
                }
            }
        });
        this.newButton = new Button(connComp, 8);
        this.newButton.setText(Messages.RemoteResourceBrowser_newConnection);
        gd = new GridData(1, 0x1000000, false, false);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IRemoteConnection conn;
                if (RemoteResourceBrowser.this.uiConnMgr != null && (conn = RemoteResourceBrowser.this.uiConnMgr.newConnection(RemoteResourceBrowser.this.getShell())) != null) {
                    RemoteResourceBrowser.this.updateConnectionCombo(conn);
                }
            }
        });
    }

    private IPath findInitialPath(String cwd, String initialPath) {
        Path path = new Path(cwd);
        if (initialPath != null) {
            Path pathToCheck = new Path(initialPath);
            if (pathToCheck.matchingFirstSegments((IPath)path) != path.segmentCount()) {
                return path;
            }
            if (this.fileMgr.getResource(initialPath).fetchInfo().exists()) {
                path = pathToCheck;
            }
        }
        return path;
    }

    private void updateConnectionCombo(IRemoteConnection conn) {
        IRemoteConnectionManager mgr = this.services.getConnectionManager();
        IRemoteConnection[] conns = mgr.getConnections();
        if (conns.length > 0) {
            Arrays.sort(conns, new Comparator<IRemoteConnection>(){

                @Override
                public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
        }
        this.connectionCombo.removeAll();
        int selected = -1;
        int i = 0;
        while (i < conns.length) {
            this.connectionCombo.add(conns[i].getName());
            if (conn != null && conn.equals(conns[i])) {
                selected = i;
            }
            ++i;
        }
        if (selected < 0) {
            this.connectionCombo.deselectAll();
        } else {
            this.connectionCombo.select(selected);
        }
        this.connectionSelected();
    }

    private void updateDialog() {
        if (this.remotePathText.getText().equals(EMPTY_STRING)) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return buttons;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.dialogTitle);
        this.remotePathText.setText(this.remotePath);
        if (this.showConnections) {
            this.updateConnectionCombo(this.connection);
        } else {
            this.changeInput(this.connection);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite dialogComp = new Composite(main, 0);
        dialogComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        dialogComp.setLayout((Layout)layout);
        Label label = new Label(dialogComp, 0);
        label.setText(this.dialogLabel);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        if (this.showConnections) {
            this.createConnectionChooser(dialogComp);
        }
        this.remotePathText = new Text(main, 2052);
        this.remotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteResourceBrowser.this.remotePath = RemoteResourceBrowser.this.remotePathText.getText();
                RemoteResourceBrowser.this.updateDialog();
            }
        });
        gd = new GridData(768);
        gd.widthHint = 300;
        this.remotePathText.setLayoutData((Object)gd);
        this.tree = (this.optionFlags & 2) == 2 ? new Tree(main, 2050) : new Tree(main, 2052);
        GridData data = new GridData(1808);
        data.heightHint = Math.max(main.getParent().getSize().y, 300);
        this.tree.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(this.tree){

            public boolean isExpandable(Object element) {
                ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
                if (cp == null) {
                    return false;
                }
                return cp.hasChildren(element);
            }
        };
        this.treeViewer.setContentProvider((IContentProvider)new RemoteContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object element = ss.getFirstElement();
                    if (element instanceof DeferredFileStore) {
                        DeferredFileStore dfs = (DeferredFileStore)element;
                        if (RemoteResourceBrowser.this.browserType == 2) {
                            if (dfs.isContainer()) {
                                RemoteResourceBrowser.this.remotePathText.setText(dfs.getFileStore().toURI().getPath());
                            }
                        } else if (dfs.isContainer()) {
                            event.getSelectionProvider().setSelection(null);
                        } else {
                            RemoteResourceBrowser.this.remotePathText.setText(dfs.getFileStore().toURI().getPath());
                        }
                    }
                    Vector<String> selectedPaths = new Vector<String>(ss.size());
                    for (Object currentSelection : ss) {
                        if (!(currentSelection instanceof DeferredFileStore) || ((DeferredFileStore)currentSelection).isContainer()) continue;
                        selectedPaths.add(((DeferredFileStore)currentSelection).getFileStore().toURI().getPath());
                    }
                    RemoteResourceBrowser.this.remotePaths = new String[selectedPaths.size()];
                    int i = 0;
                    for (String s : selectedPaths) {
                        ((RemoteResourceBrowser)RemoteResourceBrowser.this).remotePaths[i++] = s;
                    }
                }
            }
        });
        this.treeViewer.setComparator((ViewerComparator)new RemoteResourceComparator());
        return main;
    }
}

