/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.remote.ui.messages.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteDirectoryWidget
extends Composite {
    private final Text text;
    private final Button browseButton;
    private final Button defaultButton;
    private String fDefaultPath = null;
    private String fBrowseMessage = Messages.RemoteDirectoryWidget_0;
    private IRemoteConnection fRemoteConnection;
    private IRemoteServices fRemoteServices;
    private ListenerList modifyListeners = new ListenerList();
    private Map<String, String> previousSelections = new HashMap<String, String>();

    public RemoteDirectoryWidget(Composite parent, int style, String title, String defaultPath) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        RemoteDirectoryWidget body = this;
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            body = group;
        }
        Composite textComp = new Composite((Composite)body, 0);
        textComp.setLayout((Layout)new GridLayout(2, false));
        textComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(textComp, 0);
        label.setText(Messages.RemoteDirectoryWidget_1);
        this.text = new Text(textComp, 2048);
        GridData data = new GridData(4, 4, true, false);
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = RemoteDirectoryWidget.this.text.getText();
                RemoteDirectoryWidget.this.setSavedPath(path);
                RemoteDirectoryWidget.this.notifyListeners(e);
            }
        });
        Composite buttonComp = new Composite((Composite)body, 0);
        buttonComp.setLayout((Layout)new GridLayout(2, true));
        GridData buttonCompData = new GridData(4, 4, false, false);
        buttonCompData.horizontalAlignment = 0x1000008;
        buttonComp.setLayoutData((Object)buttonCompData);
        this.browseButton = new Button(buttonComp, 0);
        this.browseButton.setText(Messages.RemoteDirectoryWidget_2);
        GridData browseButtonData = new GridData(1, 4, false, false);
        browseButtonData.widthHint = 110;
        this.browseButton.setLayoutData((Object)browseButtonData);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDirectoryWidget.this.browse();
            }
        });
        this.defaultButton = new Button(buttonComp, 0);
        this.defaultButton.setText(Messages.RemoteDirectoryWidget_3);
        GridData defaultButtonData = new GridData(1, 4, false, false);
        defaultButtonData.widthHint = 110;
        this.defaultButton.setLayoutData((Object)defaultButtonData);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDirectoryWidget.this.restoreDefault(RemoteDirectoryWidget.this.fDefaultPath);
            }
        });
        if (defaultPath != null) {
            this.text.setText(defaultPath);
        }
        this.updateBrowseButton();
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add((Object)listener);
    }

    public String getLocationPath() {
        return this.text.getText();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove((Object)listener);
    }

    public void setBrowseMessage(String message) {
        this.fBrowseMessage = message;
    }

    public void setConnection(IRemoteServices services, IRemoteConnection conn) {
        if (services == null || conn == null) {
            throw new NullPointerException();
        }
        if (!services.equals(this.fRemoteServices) || !conn.equals(this.fRemoteConnection)) {
            this.fRemoteConnection = conn;
            this.fRemoteServices = services;
            String path = this.getSavedPath();
            this.restoreDefault(path);
            this.updateBrowseButton();
        }
    }

    public void setLocationPath(String path) {
        if (path != null && !path.equals(this.getLocationPath())) {
            this.text.setText(path);
        }
    }

    private void browse() {
        IRemoteUIConnectionManager connMgr = this.getUIConnectionManager();
        if (connMgr != null) {
            IRemoteUIFileManager fileMgr;
            connMgr.openConnectionWithProgress(this.getShell(), this.fRemoteConnection);
            if (this.fRemoteConnection.isOpen() && (fileMgr = this.getUIFileManager()) != null) {
                fileMgr.setConnection(this.fRemoteConnection);
                String path = fileMgr.browseDirectory(this.getShell(), this.fBrowseMessage, "", 0);
                if (path != null) {
                    this.setLocationPath(path);
                }
            }
        }
    }

    private String getSavedPath() {
        if (this.fRemoteServices != null) {
            return this.previousSelections.get(String.valueOf(this.fRemoteServices.getId()) + "." + this.fRemoteConnection.getName());
        }
        return null;
    }

    private IRemoteUIFileManager getUIFileManager() {
        if (this.fRemoteServices != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteServices).getUIFileManager();
        }
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fRemoteServices != null) {
            return PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.fRemoteServices).getUIConnectionManager();
        }
        return null;
    }

    private void notifyListeners(ModifyEvent e) {
        Object[] objectArray = this.modifyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ModifyListener)listener).modifyText(e);
            ++n2;
        }
    }

    private void restoreDefault(String path) {
        if (path == null && this.fRemoteConnection != null) {
            path = this.fRemoteServices.getFileManager(this.fRemoteConnection).getWorkingDirectory().toString();
        }
        if (path == null) {
            path = "";
        }
        this.setLocationPath(path);
    }

    private void setSavedPath(String path) {
        if (this.fRemoteServices != null) {
            this.previousSelections.put(String.valueOf(this.fRemoteServices.getId()) + "." + this.fRemoteConnection.getName(), path);
        }
    }

    private void updateBrowseButton() {
        this.browseButton.setEnabled(this.getUIFileManager() != null);
    }
}

