/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.pbs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.pbs.core.rmsystem.IPBSResourceManagerConfiguration;
import org.eclipse.ptp.rm.pbs.ui.messages.Messages;
import org.eclipse.ptp.ui.wizards.IRMConfigurationWizard;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PBSConfigurationWizardPage
extends RMConfigurationWizardPage {
    public static final String EMPTY_STRING = "";
    private IPBSResourceManagerConfiguration config;
    private String pbsdPath = "";
    private String pbsdArgs = "";
    private IRemoteServices remoteServices = null;
    private IRemoteConnection connection = null;
    private boolean loading = true;
    private boolean isValid;
    private boolean useDefaults;
    private Text pathText = null;
    private Text argsText = null;
    private Button browseButton = null;
    private Button defaultButton = null;
    private WidgetListener listener = new WidgetListener();

    public PBSConfigurationWizardPage(IRMConfigurationWizard wizard) {
        super(wizard, Messages.PBSConfigurationWizardPage_name);
        this.setTitle(Messages.PBSConfigurationWizardPage_title);
        this.setDescription(Messages.PBSConfigurationWizardPage_description);
        this.setPageComplete(true);
        this.isValid = true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        composite.setLayout((Layout)topLayout);
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    public boolean performOk() {
        this.store();
        this.config.setUseDefaults(this.useDefaults);
        if (!this.useDefaults) {
            this.config.setPBSdPath(this.pbsdPath);
            this.config.setPBSdArgs(this.pbsdArgs);
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.initContents();
        }
        super.setVisible(visible);
    }

    private void createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        contents.setLayoutData((Object)gd);
        this.defaultButton = this.createCheckButton(contents, Messages.PBSConfigurationWizardPage_defaultButton);
        this.defaultButton.addSelectionListener((SelectionListener)this.listener);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.defaultButton.setLayoutData((Object)gd);
        Label label = new Label(contents, 0);
        label.setText(Messages.PBSConfigurationWizardPage_path);
        this.pathText = new Text(contents, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 60;
        this.pathText.setLayoutData((Object)gd);
        this.pathText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton((Composite)contents, (String)Messages.PBSConfigurationWizardPage_browseButton, null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        label = new Label(contents, 0);
        label.setText(Messages.PBSConfigurationWizardPage_arguments);
        this.argsText = new Text(contents, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.argsText.setLayoutData((Object)gd);
        this.argsText.addModifyListener((ModifyListener)this.listener);
    }

    private void initContents() {
        this.loading = true;
        this.config = (IPBSResourceManagerConfiguration)this.getConfigurationWizard().getConfiguration();
        this.loadSaved();
        this.updateSettings();
        this.defaultSetting();
        this.loading = false;
        this.updatePage();
    }

    private void loadSaved() {
        this.useDefaults = this.config.getUseDefaults();
        this.pbsdPath = this.config.getPBSdPath();
        this.pbsdArgs = this.config.getPBSdArgs();
    }

    private void setValid(boolean b) {
        this.isValid = b;
        this.setPageComplete(this.isValid);
    }

    private void store() {
        if (!this.loading) {
            if (this.defaultButton != null) {
                this.useDefaults = this.defaultButton.getSelection();
            }
            if (this.pathText != null) {
                this.pbsdPath = this.pathText.getText();
            }
            if (this.argsText != null) {
                this.pbsdArgs = this.argsText.getText();
            }
        }
    }

    private void updateSettings() {
        this.store();
        this.pathText.setEnabled(!this.useDefaults);
        this.argsText.setEnabled(!this.useDefaults);
        this.browseButton.setEnabled(!this.useDefaults);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected Button createRadioButton(Composite parent, String label, String value, SelectionListener listener) {
        Button button = this.createButton(parent, label, 16400);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected void defaultSetting() {
        this.defaultButton.setSelection(this.useDefaults);
        this.pathText.setText(this.pbsdPath);
        this.argsText.setText(this.pbsdArgs);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected void handlePathBrowseButtonSelected() {
        String rmID = this.config.getRemoteServicesId();
        if (rmID != null) {
            this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(rmID);
            String conn = this.config.getConnectionName();
            if (this.remoteServices != null && conn != null) {
                this.connection = this.remoteServices.getConnectionManager().getConnection(conn);
            }
        }
        if (this.connection != null) {
            if (!this.connection.isOpen()) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            PBSConfigurationWizardPage.this.connection.open(monitor);
                        }
                        catch (RemoteConnectionException e) {
                            ErrorDialog.openError((Shell)PBSConfigurationWizardPage.this.getShell(), (String)Messages.PBSConfigurationWizardPage_connection_error, (String)Messages.PBSConfigurationWizardPage_connection_error_msg, (IStatus)new Status(4, "org.eclipse.ptp.rm.pbs.ui", e.getMessage()));
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.PBSConfigurationWizardPage_connection_error, (String)Messages.PBSConfigurationWizardPage_connection_error_msg, (IStatus)new Status(4, "org.eclipse.ptp.rm.pbs.ui", e.getMessage()));
                }
                catch (InterruptedException e) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.PBSConfigurationWizardPage_connection_error, (String)Messages.PBSConfigurationWizardPage_connection_error_msg, (IStatus)new Status(4, "org.eclipse.ptp.rm.pbs.ui", e.getMessage()));
                }
            }
            IRemoteUIServices remoteUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(this.remoteServices);
            IRemoteUIFileManager fileMgr = remoteUIServices.getUIFileManager();
            String initialPath = "//";
            String selectedPath = fileMgr.browseFile(this.getControl().getShell(), Messages.PBSConfigurationWizardPage_select, initialPath, 2);
            if (selectedPath != null) {
                this.pathText.setText(selectedPath);
            }
        }
    }

    protected boolean isValidSetting() {
        String name;
        if (this.defaultButton != null && this.defaultButton.getSelection()) {
            return true;
        }
        if (this.pathText != null && (name = this.getFieldContent(this.pathText.getText())) == null) {
            this.setErrorMessage(Messages.PBSConfigurationWizardPage_invalid);
            return false;
        }
        return true;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected void updatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidSetting()) {
            this.setValid(false);
        } else {
            this.performOk();
            this.setValid(true);
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent evt) {
            Object source = evt.getSource();
            if (!(PBSConfigurationWizardPage.this.loading || source != PBSConfigurationWizardPage.this.pathText && source != PBSConfigurationWizardPage.this.argsText)) {
                PBSConfigurationWizardPage.this.updatePage();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                PBSConfigurationWizardPage.this.updatePage();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PBSConfigurationWizardPage.this.browseButton) {
                PBSConfigurationWizardPage.this.handlePathBrowseButtonSelected();
            } else {
                PBSConfigurationWizardPage.this.updateSettings();
                PBSConfigurationWizardPage.this.updatePage();
            }
        }
    }
}

