/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rmsystem;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerServiceProvider;
import org.eclipse.ptp.services.core.IServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteResourceManagerServiceProvider
extends AbstractResourceManagerServiceProvider
implements IRemoteResourceManagerConfiguration {
    private static final String TAG_PROXY_PATH = "proxyPath";
    private static final String TAG_OPTIONS = "options";
    private static final String TAG_INVOCATION_OPTIONS = "invocationOptions";
    private static final String TAG_LOCAL_ADDRESS = "localAddress";
    private List<String> invocationOptions = new ArrayList<String>();

    public AbstractRemoteResourceManagerServiceProvider() {
    }

    public AbstractRemoteResourceManagerServiceProvider(IServiceProvider provider) {
        super(provider);
    }

    @Override
    public void addInvocationOptions(String optionString) {
        if (!optionString.equals("")) {
            String[] options;
            String[] stringArray = options = optionString.split(" ");
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                this.invocationOptions.add(option);
                ++n2;
            }
        }
    }

    @Override
    public List<String> getInvocationOptions() {
        this.addInvocationOptions(this.getString(TAG_INVOCATION_OPTIONS, ""));
        return this.invocationOptions;
    }

    @Override
    public String getInvocationOptionsStr() {
        String opts = "";
        int i = 0;
        while (i < this.invocationOptions.size()) {
            if (i > 0) {
                opts = String.valueOf(opts) + " ";
            }
            opts = String.valueOf(opts) + this.invocationOptions.get(i);
            ++i;
        }
        return opts;
    }

    @Override
    public String getLocalAddress() {
        return this.getString(TAG_LOCAL_ADDRESS, "localhost");
    }

    @Override
    public int getOptions() {
        try {
            String options = this.getString(TAG_OPTIONS, null);
            if (options != null) {
                return Integer.valueOf(options);
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public String getProxyServerPath() {
        return this.getString(TAG_PROXY_PATH, "");
    }

    @Override
    public void setInvocationOptions(String optionString) {
        this.invocationOptions.clear();
        this.addInvocationOptions(optionString);
        this.putString(TAG_INVOCATION_OPTIONS, this.getInvocationOptionsStr());
    }

    @Override
    public void setLocalAddress(String localAddr) {
        this.putString(TAG_LOCAL_ADDRESS, localAddr);
    }

    @Override
    public void setOptions(int options) {
        this.putString(TAG_OPTIONS, String.valueOf(options));
    }

    @Override
    public void setProxyServerPath(String proxyServerPath) {
        this.putString(TAG_PROXY_PATH, proxyServerPath);
    }

    @Override
    public boolean testOption(int option) {
        return (this.getOptions() & option) == option;
    }
}

