/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.rm.core.RMCorePlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public abstract class AbstractRemoteCommandJob
extends Job {
    protected static final String EMPTY_STRING = "";
    protected String fCommand;
    protected String fInterruptedErrorMessage;
    protected String fProcessErrorMessage;
    protected String fParsingErrorMessage;
    protected int fReschedule = 0;
    protected IRemoteProcess fJobProcess;
    protected AbstractToolRuntimeSystem fRtSystem;
    protected IProgressMonitor fMonitor;

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage, IProgressMonitor monitor) {
        super(name);
        this.fRtSystem = rtSystem;
        this.fCommand = command;
        this.fInterruptedErrorMessage = interruptedErrorMessage;
        this.fProcessErrorMessage = processErrorMessage;
        this.fParsingErrorMessage = parsingErrorMessage;
        this.fMonitor = monitor;
    }

    public AbstractRemoteCommandJob(AbstractToolRuntimeSystem rtSystem, String name, String command, String interruptedErrorMessage, String processErrorMessage, String parsingErrorMessage, int reschedule, IProgressMonitor monitor) {
        super(name);
        this.fRtSystem = rtSystem;
        this.fCommand = command;
        this.fInterruptedErrorMessage = interruptedErrorMessage;
        this.fProcessErrorMessage = processErrorMessage;
        this.fParsingErrorMessage = parsingErrorMessage;
        this.fReschedule = reschedule;
        this.fMonitor = monitor;
    }

    protected abstract IStatus parse(BufferedReader var1) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            Assert.isNotNull((Object)this.fRtSystem);
            Assert.isNotNull((Object)this.fCommand);
            Assert.isTrue((boolean)(this.fCommand.trim().equals("") == false));
            if (this.fMonitor == null) {
                this.fMonitor = monitor;
            }
            argumentParser = new ArgumentParser(this.fCommand);
            arguments = argumentParser.getTokenList();
            if (!this.fMonitor.isCanceled()) ** GOTO lbl-1000
            var8_5 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
            var9_15 = this;
            ** GOTO lbl30
        }
        catch (Exception e) {
            try {
                DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command failed: {0}", new Object[]{e});
                var8_14 = new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractRemoteCommandJob_Exception_InternalError, (Throwable)e);
                var9_24 = this;
            }
            catch (Throwable var7_31) {
                var9_25 = this;
                synchronized (var9_25) {
                    if (this.fJobProcess != null) {
                        this.fJobProcess.destroy();
                    }
                    this.fJobProcess = null;
                    throw var7_31;
                }
            }
lbl30:
            // 1 sources

            synchronized (var9_15) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_5;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    cmdBuilder = this.fRtSystem.createProcessBuilder(arguments);
                    var5_28 = this;
                    synchronized (var5_28) {
                        DebugUtil.trace(DebugUtil.COMMAND_TRACING, "Run command: {0}", new Object[]{this.fCommand});
                        this.fJobProcess = cmdBuilder.start();
                    }
                }
                catch (IOException e) {
                    var8_6 = new Status(4, "org.eclipse.ptp.rm.core", this.fProcessErrorMessage, (Throwable)e);
                    var9_16 = this;
                    synchronized (var9_16) {
                        if (this.fJobProcess != null) {
                            this.fJobProcess.destroy();
                        }
                        this.fJobProcess = null;
                        return var8_6;
                    }
                }
            }
            {
                if (!this.fMonitor.isCanceled()) ** GOTO lbl-1000
                var8_7 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                var9_17 = this;
            }
            synchronized (var9_17) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_7;
            }
lbl-1000:
            // 1 sources

            {
                stdout = new BufferedReader(new InputStreamReader(this.fJobProcess.getInputStream()));
                parseStatus = this.parse(stdout);
                if (parseStatus.getSeverity() != 4) ** GOTO lbl92
                DebugUtil.error(DebugUtil.COMMAND_TRACING_MORE, "Command parsing failed: {0}", new Object[]{parseStatus.getMessage()});
                var8_8 = parseStatus;
                var9_18 = this;
            }
            synchronized (var9_18) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_8;
            }
lbl-1000:
            // 1 sources

            {
                System.out.println("waiting for job");
                var6_29 = this;
                synchronized (var6_29) {
                    this.wait(500L);
                    continue;
                }
lbl92:
                // 2 sources

                ** while (!this.fJobProcess.isCompleted() && !this.fMonitor.isCanceled())
            }
lbl93:
            // 1 sources

            if (!this.fMonitor.isCanceled()) ** GOTO lbl-1000
            var8_9 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
            var9_19 = this;
            synchronized (var9_19) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_9;
            }
lbl-1000:
            // 1 sources

            {
                if (this.fJobProcess.exitValue() == 0) ** GOTO lbl-1000
                var8_10 = new Status(4, RMCorePlugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)"Command failed with exit status {0}", (Object)this.fJobProcess.exitValue()), null);
                var9_20 = this;
            }
            synchronized (var9_20) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_10;
            }
lbl-1000:
            // 1 sources

            {
                if (!this.fMonitor.isCanceled()) ** GOTO lbl-1000
                var8_11 = new Status(8, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, null);
                var9_21 = this;
            }
            synchronized (var9_21) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: waiting to finish.");
                    this.fJobProcess.waitFor();
                }
                catch (InterruptedException e) {
                    var8_12 = new Status(1, "org.eclipse.ptp.rm.core", this.fInterruptedErrorMessage, (Throwable)e);
                    var9_22 = this;
                    synchronized (var9_22) {
                        if (this.fJobProcess != null) {
                            this.fJobProcess.destroy();
                        }
                        this.fJobProcess = null;
                        return var8_12;
                    }
                }
            }
            {
                DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: exit value {0}.", new Object[]{this.fJobProcess.exitValue()});
                if (this.fReschedule > 0) {
                    DebugUtil.trace(DebugUtil.COMMAND_TRACING_MORE, "Command: reschedule in {0} miliseconds.", new Object[]{this.fReschedule});
                    this.schedule(this.fReschedule);
                }
                var8_13 = parseStatus;
                var9_23 = this;
            }
            synchronized (var9_23) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_13;
            }
            synchronized (var9_24) {
                if (this.fJobProcess != null) {
                    this.fJobProcess.destroy();
                }
                this.fJobProcess = null;
                return var8_14;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        AbstractRemoteCommandJob abstractRemoteCommandJob = this;
        synchronized (abstractRemoteCommandJob) {
            if (this.fJobProcess != null) {
                this.fJobProcess.destroy();
                this.fJobProcess = null;
            }
        }
    }
}

