/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLaunchUtils {
    public static String findToolBinPath(String toolfind, String suggPath, String queryText, String queryMessage, Shell selshell) {
        String vtbinpath = BuildLaunchUtils.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = BuildLaunchUtils.askToolPath(suggPath, queryText, queryMessage, selshell)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    public static String findToolBinPath(String toolfind, String suggPath, String toolName, Shell selshell) {
        String vtbinpath = BuildLaunchUtils.checkToolEnvPath(toolfind);
        if ((vtbinpath == null || vtbinpath.equals("")) && (vtbinpath = BuildLaunchUtils.askToolPath(suggPath, toolName, selshell)) == null) {
            vtbinpath = "";
        }
        return vtbinpath;
    }

    public static String getToolPath(String toolID) {
        String toolBinID;
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        String path = pstore.getString(toolBinID = "performance_tool_bin_directory." + toolID);
        if (path != null) {
            return path;
        }
        return "";
    }

    public static void getAllToolPaths(ExternalToolProcess[] tools, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Shell ourshell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        int i = 0;
        while (i < tools.length) {
            for (Map.Entry me2 : tools[i].groupApp.entrySet()) {
                entry = (String)me2.getKey();
                if (entry.equals("internal")) continue;
                String toolBinID = "performance_tool_bin_directory." + entry;
                if (!force && !pstore.getString(toolBinID).equals("")) continue;
                pstore.setValue(toolBinID, BuildLaunchUtils.findToolBinPath((String)me2.getValue(), null, entry, ourshell));
            }
            ++i;
        }
    }

    public static void verifyRequestToolPath(ExternalToolProcess tool, boolean force) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Shell ourshell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            entry = (String)me2.getKey();
            if (entry.equals("internal")) continue;
            String toolBinID = "performance_tool_bin_directory." + entry;
            if (!force && !pstore.getString(toolBinID).equals("")) continue;
            pstore.setValue(toolBinID, BuildLaunchUtils.findToolBinPath((String)me2.getValue(), null, entry, ourshell));
        }
    }

    public static void verifyEnvToolPath(ExternalToolProcess tool) {
        IPreferenceStore pstore = Activator.getDefault().getPreferenceStore();
        Iterator eIt = null;
        Map.Entry me2 = null;
        String entry = null;
        String toolBinID = null;
        String curTool = null;
        for (Map.Entry me2 : tool.groupApp.entrySet()) {
            String gVal;
            entry = (String)me2.getKey();
            if (entry.equals("internal") || (curTool = pstore.getString(toolBinID = "performance_tool_bin_directory." + entry)) != null && !curTool.equals("") && new File(curTool).exists() || (gVal = (String)me2.getValue()) == null || gVal.trim().length() <= 0 || (curTool = BuildLaunchUtils.checkToolEnvPath(gVal)) == null) continue;
            pstore.setValue(toolBinID, curTool);
        }
    }

    public static String checkToolEnvPath(String toolname) {
        if (Platform.getOS().toLowerCase().trim().indexOf("win") >= 0) {
            return null;
        }
        String pPath = null;
        try {
            Process p = new ProcessBuilder("which", toolname).start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            pPath = reader.readLine();
            while (reader.readLine() != null) {
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pPath == null) {
            return null;
        }
        File test = new File(pPath);
        File toolin = new File(toolname);
        if (test.getPath().equals(toolin.getPath())) {
            return null;
        }
        if (test.exists()) {
            return test.getParentFile().getPath();
        }
        return null;
    }

    public static String askToolPath(String archpath, String toolText, String toolMessage, Shell selshell) {
        File path;
        if (selshell == null) {
            return null;
        }
        DirectoryDialog dialog = new DirectoryDialog(selshell);
        dialog.setText(toolText);
        dialog.setMessage(toolMessage);
        if (archpath != null && (path = new File(archpath)).exists()) {
            dialog.setFilterPath(path.isFile() ? archpath : path.getParent());
        }
        return dialog.open();
    }

    public static String askToolPath(String archpath, String toolName, Shell selshell) {
        return BuildLaunchUtils.askToolPath(archpath, "Select " + toolName + " Bin Directory", "Please select the directory containing " + toolName, selshell);
    }

    public static String getNow() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public static boolean runTool(List<String> tool, Map<String, String> env, File directory) {
        return BuildLaunchUtils.runTool(tool, env, directory, null);
    }

    public static boolean runTool(List<String> tool, Map<String, String> env, File directory, String output) {
        int eval = -1;
        try {
            FileOutputStream fos = null;
            if (output != null) {
                File test = new File(output);
                File parent = test.getParentFile();
                if (parent == null || !parent.canRead()) {
                    output = directory + File.separator + output;
                }
                fos = new FileOutputStream(output);
            }
            ProcessBuilder pb = new ProcessBuilder(tool);
            pb.directory(directory);
            if (env != null) {
                pb.environment().putAll(env);
            }
            Process p = pb.start();
            StreamRunner outRun = new StreamRunner(p.getInputStream(), "out", fos);
            StreamRunner errRun = new StreamRunner(p.getErrorStream(), "err", null);
            outRun.start();
            errRun.start();
            outRun.join();
            eval = p.waitFor();
            if (fos != null) {
                fos.flush();
                ((OutputStream)fos).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return eval == 0;
    }

    public static boolean runVis(List<String> tool, Map<String, String> env, File directory) {
        int eval = -1;
        try {
            ProcessBuilder pb = new ProcessBuilder(tool);
            pb.directory(directory);
            if (env != null) {
                pb.environment().putAll(env);
            }
            pb.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return eval == 0;
    }

    static class StreamRunner
    extends Thread {
        InputStream is;
        OutputStream os;
        String type;

        StreamRunner(InputStream is, String type, OutputStream os) {
            this.is = is;
            this.os = os;
            this.type = type;
        }

        public void run() {
            try {
                PrintWriter pw = null;
                if (this.os != null) {
                    pw = new PrintWriter(this.os);
                }
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (pw != null) {
                        pw.println(line);
                        continue;
                    }
                    System.out.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

