/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.etfw.Activator;
import org.eclipse.ptp.etfw.internal.BuilderTool;
import org.eclipse.ptp.etfw.internal.ILaunchFactory;
import org.eclipse.ptp.etfw.internal.LauncherTool;
import org.eclipse.ptp.etfw.internal.ParametricToolLaunchManager;
import org.eclipse.ptp.etfw.internal.PostlaunchTool;
import org.eclipse.ptp.etfw.internal.ToolStep;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;

public class ToolLaunchManager {
    protected static final String buildText = "Instrumenting and Building";
    protected static final String launchText = "Executing Instrumented Project";
    protected static final String collectText = "Collecting Performance Data";
    protected LaunchConfigurationDelegate paraDel;
    private ILaunchFactory lf = null;

    public ToolLaunchManager(LaunchConfigurationDelegate delegate, ILaunchFactory lf) {
        this.paraDel = delegate;
        this.lf = lf;
    }

    private static boolean runStep(ToolStep step) {
        step.schedule();
        try {
            step.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return step.getResult().isOK();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        boolean useParam;
        ILaunch launch = launchIn;
        ExternalToolProcess pproc = Activator.getTool(configuration.getAttribute("selected_performance_tool", null));
        boolean bl = useParam = configuration.getAttribute("use the parametric analysis system", false) || pproc.para != null && pproc.para.runParametric;
        if (useParam) {
            ParametricToolLaunchManager.launch(configuration, this.paraDel, this.lf, mode, launchIn, monitor);
            return;
        }
        String bProgPath = null;
        String bOutLoc = null;
        boolean ran = false;
        BuilderTool builder = null;
        LauncherTool launcher = null;
        boolean buildOnly = configuration.getAttribute("build_but_do_not_run_instrumented_executable", false);
        boolean analyzeOnly = configuration.getAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", false);
        BuildTool bt = pproc.getFirstBuilder(configuration);
        PostProcTool ppt = pproc.getFirstAnalyzer(configuration);
        ExecTool et = pproc.getFirstRunner(configuration);
        if (buildOnly) {
            builder = new BuilderTool(configuration, bt);
            ToolLaunchManager.runStep(builder);
            return;
        }
        boolean bl2 = analyzeOnly = analyzeOnly || bt == null && ppt != null && et == null;
        if (analyzeOnly) {
            PostlaunchTool analyzer = new PostlaunchTool(configuration, ppt, null);
            ToolLaunchManager.runStep(analyzer);
            return;
        }
        if (!pproc.recompile) {
            builder = new BuilderTool(configuration, null);
            if (!ToolLaunchManager.runStep(builder)) {
                return;
            }
            bProgPath = builder.getProgramPath();
            bOutLoc = builder.getOutputLocation();
            if (!(pproc.prependExecution || pproc.externalTools.get(0) instanceof ExecTool || pproc.explicitExecution)) {
                launcher = new LauncherTool(configuration, null, bProgPath, this.paraDel, launch);
                if (!ToolLaunchManager.runStep(launcher)) {
                    return;
                }
                ran = true;
            }
        }
        int i = 0;
        while (i < pproc.externalTools.size()) {
            ExternalTool t = (ExternalTool)pproc.externalTools.get(i);
            if (t.canRun(configuration)) {
                PostlaunchTool analyzer;
                if (t instanceof BuildTool) {
                    builder = new BuilderTool(configuration, (BuildTool)t);
                    if (!ToolLaunchManager.runStep(builder)) {
                        return;
                    }
                    bProgPath = builder.getProgramPath();
                    bOutLoc = builder.getOutputLocation();
                    if (!(pproc.prependExecution || ran || i >= pproc.externalTools.size() - 1 || pproc.externalTools.get(i + 1) instanceof ExecTool || pproc.explicitExecution)) {
                        launcher = new LauncherTool(configuration, null, bProgPath, this.paraDel, launch);
                        if (!ToolLaunchManager.runStep(launcher)) {
                            return;
                        }
                        ran = true;
                    }
                } else if (t instanceof ExecTool ? !ToolLaunchManager.runStep(launcher = new LauncherTool(configuration, (ExecTool)t, bProgPath, this.paraDel, launch)) : t instanceof PostProcTool && !ToolLaunchManager.runStep(analyzer = new PostlaunchTool(configuration, (PostProcTool)t, bOutLoc))) {
                    return;
                }
            }
            ++i;
        }
    }
}

