/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.swt.widgets.Shell;

public class ResolveInterfaceBinding
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                progressMonitor.beginTask("Waiting for background work to complete (Photran indexer)", -1);
                Token token = this.findEnclosingToken(this.getAST(), this.getFortranEditor().getSelection());
                if (token == null) {
                    throw new Exception("Please select a token.");
                }
                Definition def = PhotranVPG.getInstance().getDefinitionFor(token.getTokenRef());
                if (def == null) {
                    throw new Exception("Please select the identifier in a subprogram declaration.");
                }
                this.openSelectionDialog(def.resolveInterfaceBinding());
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = e.getClass().getName();
                }
                MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

