/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.properties.WorkspacePathEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SearchPathsPropertyPage
extends PropertyPage {
    private FortranBooleanFieldEditor enableVPG;
    private FortranBooleanFieldEditor enableDeclView;
    private FortranBooleanFieldEditor enableContentAssist;
    private FortranBooleanFieldEditor enableHoverTip;
    private WorkspacePathEditor modulePathEditor;
    private WorkspacePathEditor includePathEditor;

    protected Control createContents(Composite parent) {
        IProject proj = (IProject)this.getElement();
        SearchPathProperties.setProject((IProject)proj);
        ScopedPreferenceStore scopedStore = SearchPathProperties.scopedStore;
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label l = new Label(composite, 64);
        l.setText("To enable Open Declaration, Find All References, the Fortran Declaration\nview, content assist, and refactoring in Fortran programs, check the\nfollowing box.  A program database (index) will be updated every time\na Fortran file is created or saved.");
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.enableVPG = new FortranBooleanFieldEditor("EnableVPG", "Enable Fortran analysis/refactoring", composite){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                SearchPathsPropertyPage.this.enableDeclView.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableContentAssist.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableHoverTip.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableDeclView.setValue(newValue);
                SearchPathsPropertyPage.this.enableContentAssist.setValue(newValue);
                SearchPathsPropertyPage.this.enableHoverTip.setValue(newValue);
            }
        };
        this.enableVPG.setPreferenceStore((IPreferenceStore)scopedStore);
        this.enableVPG.load();
        SearchPathProperties.setProperty((IProject)proj, (String)"EnableVPG", (String)String.valueOf(this.enableVPG.getBooleanValue()));
        this.enableDeclView = new FortranBooleanFieldEditor("EnableDeclView", "Enable Fortran Declaration view", composite);
        this.enableDeclView.setPreferenceStore((IPreferenceStore)scopedStore);
        this.enableDeclView.load();
        this.enableContentAssist = new FortranBooleanFieldEditor("EnableContentAssist", "Enable Fortran content assist (Ctrl+Space)", composite);
        this.enableContentAssist.setPreferenceStore((IPreferenceStore)scopedStore);
        this.enableContentAssist.load();
        this.enableHoverTip = new FortranBooleanFieldEditor("EnableHoverTip", "Enable Fortran Hover tips", composite);
        this.enableHoverTip.setPreferenceStore((IPreferenceStore)scopedStore);
        this.enableHoverTip.load();
        this.enableDeclView.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableContentAssist.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableHoverTip.setEnabled(this.enableVPG.getBooleanValue(), composite);
        l = new Label(composite, 64);
        l.setLayoutData((Object)new GridData(4, 128, true, true));
        l = new Label(composite, 64);
        l.setText("The following specify the paths searched for modules\nand INCLUDE files during analysis and refactoring.\nThese MAY BE DIFFERENT from the settings used by\nyour compiler to build your project.");
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.modulePathEditor = new WorkspacePathEditor((IProject)this.getElement(), "FortranModulePaths", "Folders to be searched for &modules, in order of preference:", "Select a folder to be searched for Fortran modules:", composite);
        this.modulePathEditor.setPreferenceStore((IPreferenceStore)scopedStore);
        this.modulePathEditor.load();
        this.includePathEditor = new WorkspacePathEditor((IProject)this.getElement(), "FortranIncludePaths", "Folders to be searched for &INCLUDE files, in order of preference:", "Select a folder to be searched for INCLUDE files:", composite);
        this.includePathEditor.setPreferenceStore((IPreferenceStore)scopedStore);
        this.includePathEditor.load();
        return composite;
    }

    public void performDefaults() {
        this.enableVPG.loadDefault();
        this.enableDeclView.loadDefault();
        this.enableContentAssist.loadDefault();
        this.enableHoverTip.loadDefault();
        this.modulePathEditor.loadDefault();
        this.includePathEditor.loadDefault();
    }

    public boolean performOk() {
        this.enableVPG.store();
        this.enableDeclView.store();
        this.enableContentAssist.store();
        this.enableHoverTip.store();
        this.modulePathEditor.store();
        this.includePathEditor.store();
        ScopedPreferenceStore scopedStore = SearchPathProperties.scopedStore;
        try {
            scopedStore.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Preferences Changed", (String)"You may need to close and re-open any Fortran editors for the new settings to take effect.");
        PhotranVPG.getInstance().queueJobToEnsureVPGIsUpToDate();
        return true;
    }

    public static class FortranBooleanFieldEditor
    extends BooleanFieldEditor {
        private Button myCheckBox;

        public FortranBooleanFieldEditor(String enableVpgPropertyName, String string, Composite composite) {
            super(enableVpgPropertyName, string, composite);
        }

        protected Button getChangeControl(Composite parent) {
            if (this.myCheckBox == null) {
                this.myCheckBox = new Button(parent, 16416);
                this.myCheckBox.setFont(parent.getFont());
                this.myCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean isSelected = FortranBooleanFieldEditor.this.myCheckBox.getSelection();
                        FortranBooleanFieldEditor.this.valueChanged(!isSelected, isSelected);
                    }
                });
                this.myCheckBox.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        FortranBooleanFieldEditor.this.myCheckBox = null;
                    }
                });
            } else {
                this.checkParent((Control)this.myCheckBox, parent);
            }
            return this.myCheckBox;
        }

        public void setValue(boolean value) {
            if (this.myCheckBox != null) {
                this.myCheckBox.setSelection(value);
            }
        }
    }
}

