/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SearchMessages {
    private static final String RESOURCE_BUNDLE = SearchMessages.class.getName();
    private static ResourceBundle fgResourceBundle;

    static {
        try {
            fgResourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    private SearchMessages() {
    }

    public static String getString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static String getFormattedString(String key, Object[] args) {
        String format = SearchMessages.getString(key);
        return MessageFormat.format(format, args);
    }

    public static String getFormattedString(String key, Object arg) {
        return SearchMessages.getFormattedString(key, new Object[]{arg});
    }
}

