/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.eclipse.VPGSchedulingRule;
import org.eclipse.rephraserengine.ui.IEclipseVPGFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.progress.IProgressService;

public abstract class VPGWindowActionDelegate
implements IWorkbenchWindowActionDelegate,
IRunnableWithProgress {
    private static final String VPG_EXTENSION_POINT_ID = "org.eclipse.rephraserengine.ui.vpg.vpg";
    private EclipseVPG vpg = null;
    protected IWorkbenchWindow activeWindow = null;
    protected Shell activeShell = null;

    public final void init(IWorkbenchWindow window) {
        this.activeWindow = window;
        if (this.activeWindow != null) {
            this.activeShell = this.activeWindow.getShell();
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public final void run(IAction action) {
        this.vpg = this.determineVPG();
        if (this.vpg == null) {
            MessageDialog.openError((Shell)this.activeShell, (String)"Error", (String)"None of the available refactoring engines have made their program databases (VPGs) available to this action.");
        } else {
            this.scheduleThisUsingVPGSchedulingRule();
        }
    }

    private void scheduleThisUsingVPGSchedulingRule() {
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        IWorkspaceRoot lockEntireWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        VPGSchedulingRule vpgSched = VPGSchedulingRule.getInstance();
        ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule)lockEntireWorkspace, (ISchedulingRule)vpgSched);
        try {
            context.runInUI((IRunnableContext)context, (IRunnableWithProgress)this, schedulingRule);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.activeShell, (String)"Unhandled Exception", (String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private EclipseVPG determineVPG() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(VPG_EXTENSION_POINT_ID);
        if (configs.length == 0) {
            return null;
        }
        return this.createVPG(configs, this.determineWhichVPGToUse(configs));
    }

    private EclipseVPG createVPG(IConfigurationElement[] configs, int index) {
        block3: {
            try {
                if (index >= 0) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        IEclipseVPGFactory factory = (IEclipseVPGFactory)configs[index].createExecutableExtension("class");
        return factory.getVPG();
    }

    private int determineWhichVPGToUse(IConfigurationElement[] configs) {
        if (configs.length == 1) {
            return 0;
        }
        return this.askUserWhichVPGToUse(configs);
    }

    private int askUserWhichVPGToUse(IConfigurationElement[] configs) {
        TreeMap<Integer, String> vpgs = new TreeMap<Integer, String>();
        int i = 0;
        while (i < configs.length) {
            vpgs.put(i, configs[i].getAttribute("name"));
            ++i;
        }
        ListDialog dlg = new ListDialog(this.activeShell);
        dlg.setInput(vpgs);
        dlg.setTitle("Select VPG");
        dlg.setContentProvider((IStructuredContentProvider)new ArrayPairContentProvider());
        dlg.setLabelProvider((ILabelProvider)new ArrayPairLabelProvider());
        dlg.setMessage("Please select which refactoring engine's database to use.");
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0 && dlg.getResult() != null && dlg.getResult().length > 0) {
            return (Integer)((Map.Entry)dlg.getResult()[0]).getKey();
        }
        return -1;
    }

    public final void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                this.run(this.vpg, progressMonitor);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    protected abstract void run(EclipseVPG var1, IProgressMonitor var2) throws Exception;

    protected Shell getShell() {
        return this.activeShell;
    }

    private static final class ArrayPairContentProvider
    implements IStructuredContentProvider {
        private ArrayPairContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Map)inputElement).entrySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class ArrayPairLabelProvider
    extends LabelProvider {
        private ArrayPairLabelProvider() {
        }

        public String getText(Object element) {
            return (String)((Map.Entry)element).getValue();
        }
    }
}

