/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WorkingDirectoryBlock
extends LaunchConfigurationTab {
    protected Button useDefaultWorkingDirButton = null;
    protected Button localDirButton = null;
    protected Text workingDirText = null;
    protected Button workingDirBrowseButton = null;
    protected Button workspaceDirButton = null;
    protected Text workspaceDirText = null;
    protected Button workspaceDirBrowseButton = null;
    protected ILaunchConfiguration launchConfiguration;
    protected WidgetListener listener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite workingDirComp = new Composite(parent, 0);
        workingDirComp.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        workingDirComp.setLayoutData((Object)this.spanGridData(768, 5));
        this.setControl((Control)workingDirComp);
        Label workingDirLabel = new Label(workingDirComp, 0);
        workingDirLabel.setText(Messages.WorkingDirectoryBlock_Working_directory_colon);
        workingDirLabel.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton = new Button(workingDirComp, 32);
        this.useDefaultWorkingDirButton.setText(Messages.WorkingDirectoryBlock_Use_default_working_directory);
        this.useDefaultWorkingDirButton.setLayoutData((Object)this.spanGridData(-1, 3));
        this.useDefaultWorkingDirButton.addSelectionListener((SelectionListener)this.listener);
        this.localDirButton = this.createRadioButton(workingDirComp, Messages.WorkingDirectoryBlock_Local_directory);
        this.localDirButton.addSelectionListener((SelectionListener)this.listener);
        this.workingDirText = new Text(workingDirComp, 2052);
        this.workingDirText.setLayoutData((Object)new GridData(768));
        this.workingDirText.addModifyListener((ModifyListener)this.listener);
        this.workingDirBrowseButton = this.createPushButton(workingDirComp, Messages.Tab_common_Browse_1, null);
        this.workingDirBrowseButton.addSelectionListener((SelectionListener)this.listener);
        this.workspaceDirButton = this.createRadioButton(workingDirComp, Messages.WorkingDirectoryBlock_Workspace);
        this.workspaceDirButton.addSelectionListener((SelectionListener)this.listener);
        this.workspaceDirText = new Text(workingDirComp, 2052);
        this.workspaceDirText.setLayoutData((Object)new GridData(768));
        this.workspaceDirText.addModifyListener((ModifyListener)this.listener);
        this.workspaceDirBrowseButton = this.createPushButton(workingDirComp, Messages.Tab_common_Browse_2, null);
        this.workspaceDirBrowseButton.addSelectionListener((SelectionListener)this.listener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", null);
            this.workspaceDirText.setText("");
            this.workingDirText.setText("");
            if (wd == null) {
                this.useDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(wd);
                if (path.isAbsolute()) {
                    this.workingDirText.setText(wd);
                    this.localDirButton.setSelection(true);
                    this.workspaceDirButton.setSelection(false);
                } else {
                    this.workspaceDirText.setText(wd);
                    this.workspaceDirButton.setSelection(true);
                    this.localDirButton.setSelection(false);
                }
                this.useDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.CommonTab_common_Exception_occurred_reading_configuration_EXCEPTION);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            if (this.isLocalWorkingDirectory()) {
                wd = this.getFieldContent(this.workingDirText.getText());
            } else {
                Path path = new Path(this.workspaceDirText.getText());
                wd = path.makeRelative().toOSString();
            }
        }
        configuration.setAttribute("org.eclipse.ptp.launch.WORK_DIRECTORY_ATTR", wd);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.isLocalWorkingDirectory()) {
            String workingDirPath = this.getFieldContent(this.workingDirText.getText());
            if (workingDirPath != null) {
                File dir = new File(workingDirPath);
                if (!dir.exists()) {
                    this.setErrorMessage(Messages.WorkingDirectoryBlock_Working_directory_does_not_exist);
                    return false;
                }
                if (!dir.isDirectory()) {
                    this.setErrorMessage(Messages.WorkingDirectoryBlock_Working_directory_is_not_a_directory);
                    return false;
                }
            }
        } else if (this.getContainer(this.workingDirText.getText()) == null) {
            this.setErrorMessage(Messages.WorkingDirectoryBlock_Project_or_folder_does_not_exist);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.WorkingDirectoryBlock_Working_directory;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.useDefaultWorkingDirButton.getSelection();
    }

    protected boolean isLocalWorkingDirectory() {
        return this.localDirButton.getSelection();
    }

    protected void setDefaultWorkingDir(ILaunchConfiguration configuration) {
        if (configuration == null) {
            this.workingDirText.setText(System.getProperty("user.dir"));
            this.localDirButton.setSelection(true);
            this.workspaceDirButton.setSelection(false);
            return;
        }
        IProject project = this.getProject(configuration);
        if (project == null) {
            return;
        }
        this.workspaceDirText.setText(project.getFullPath().makeRelative().toString());
        this.localDirButton.setSelection(false);
        this.workspaceDirButton.setSelection(true);
    }

    protected void handleLocationButtonSelected() {
        if (!this.isDefaultWorkingDirectory()) {
            boolean local = this.isLocalWorkingDirectory();
            this.workingDirText.setEnabled(local);
            this.workingDirBrowseButton.setEnabled(local);
            this.workspaceDirText.setEnabled(!local);
            this.workspaceDirBrowseButton.setEnabled(!local);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        if (this.isDefaultWorkingDirectory()) {
            this.setDefaultWorkingDir(this.getLaunchConfiguration());
            this.localDirButton.setEnabled(false);
            this.workingDirText.setEnabled(false);
            this.workingDirBrowseButton.setEnabled(false);
            this.workspaceDirButton.setEnabled(false);
            this.workspaceDirText.setEnabled(false);
            this.workspaceDirBrowseButton.setEnabled(false);
        } else {
            this.localDirButton.setEnabled(true);
            this.workspaceDirButton.setEnabled(true);
            this.handleLocationButtonSelected();
        }
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(Messages.WorkingDirectoryBlock_Select_working_directory_for_launch_configuration);
        String currentWorkingDir = this.workingDirText.getText();
        if (currentWorkingDir != null && !currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.workingDirText.setText(selectedDirectory);
        }
    }

    protected void handleWorkspaceDirBrowseButtonSelected() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.getWorkspaceRoot(), false, Messages.WorkingDirectoryBlock_Select_workspace_relative_working_directory);
        IContainer currentContainer = this.getContainer(this.workspaceDirText.getText());
        if (currentContainer != null) {
            IPath path = currentContainer.getFullPath();
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.workspaceDirText.setText(containerName);
        }
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.useDefaultWorkingDirButton) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.localDirButton || source == WorkingDirectoryBlock.this.workspaceDirButton) {
                WorkingDirectoryBlock.this.handleLocationButtonSelected();
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            } else if (source == WorkingDirectoryBlock.this.workingDirBrowseButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.workspaceDirBrowseButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else {
                WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
            }
        }

        public void modifyText(ModifyEvent evt) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }
    }
}

