/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rm.mpi.mpich2.core.rtsystem.MPICH2JobMap;

public class MPICH2ListJobsParser {
    private JobListState state;
    private MPICH2JobMap map = new MPICH2JobMap();
    private String errorMsg;

    private void processJobInfo(String line, MPICH2JobMap.Job job) {
        String value;
        String key;
        String[] parts = line.split("=");
        if (parts.length == 1) {
            key = parts[0].trim();
            value = "";
        } else if (parts.length == 2) {
            key = parts[0].trim();
            value = parts[1].trim();
        } else {
            this.state = JobListState.JOBLIST_ERROR;
            this.errorMsg = line;
            return;
        }
        if ("jobid".equals(key)) {
            job.setJobID(value);
        } else if ("jobalias".equals(key)) {
            job.setJobAlias(value);
        } else if ("username".equals(key)) {
            job.setUsername(value);
        } else if ("host".equals(key)) {
            job.setHost(value);
        } else if ("pid".equals(key)) {
            job.setPid(Integer.parseInt(value));
        } else if ("sid".equals(key)) {
            job.setSid(Integer.parseInt(value));
        } else if ("rank".equals(key)) {
            job.setRank(Integer.parseInt(value));
        } else if ("pgm".equals(key)) {
            job.setPgm(value);
        } else {
            this.state = JobListState.JOBLIST_ERROR;
            this.errorMsg = line;
            return;
        }
        if (job.isComplete()) {
            this.state = JobListState.JOBLIST_END;
        }
    }

    public MPICH2JobMap parse(BufferedReader reader) throws IOException {
        String line = null;
        MPICH2JobMap.Job job = null;
        this.state = JobListState.JOBLIST_INIT;
        block7: while (this.state != JobListState.JOBLIST_COMPLETE) {
            switch (this.state) {
                case JOBLIST_INIT: {
                    line = reader.readLine();
                    if (line == null) {
                        this.state = JobListState.JOBLIST_COMPLETE;
                        break;
                    }
                    if ((line = line.trim()).length() == 0) continue block7;
                    this.state = JobListState.JOBLIST_START;
                    job = this.map.new MPICH2JobMap.Job();
                    this.processJobInfo(line, job);
                    break;
                }
                case JOBLIST_START: {
                    line = reader.readLine();
                    if (line == null) {
                        this.state = JobListState.JOBLIST_END;
                        break;
                    }
                    if ((line = line.trim()).length() == 0) {
                        this.state = JobListState.JOBLIST_END;
                        break;
                    }
                    this.processJobInfo(line, job);
                    break;
                }
                case JOBLIST_END: {
                    if (job != null) {
                        if (job.isComplete()) {
                            this.map.addJob(job);
                        } else {
                            DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)("job is incomplete, skipping" + job.toString()));
                        }
                    }
                    this.state = line == null ? JobListState.JOBLIST_COMPLETE : JobListState.JOBLIST_INIT;
                    DebugUtil.trace((boolean)DebugUtil.RTS_DISCOVER_TRACING, (String)("found job " + job.toString()));
                    break;
                }
                case JOBLIST_COMPLETE: {
                    break;
                }
                case JOBLIST_ERROR: {
                    while ((line = reader.readLine()) != null) {
                        this.errorMsg = String.valueOf(this.errorMsg) + "\n" + line;
                    }
                    return null;
                }
            }
        }
        return this.map;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JobListState {
        JOBLIST_INIT,
        JOBLIST_START,
        JOBLIST_END,
        JOBLIST_COMPLETE,
        JOBLIST_ERROR;

    }
}

