/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui.wizards;

import java.util.StringTokenizer;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.rm.ibm.pe.core.PEPreferenceManager;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.IPEResourceManagerConfiguration;
import org.eclipse.ptp.rm.ibm.pe.ui.internal.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PEResourceManagerOptionDialog
extends TitleAreaDialog {
    private static final String SUSPEND_AT_STARTUP_OPTION = "--suspend_at_startup";
    private static final String USE_LOADLEVELER_OPTION = "--useloadleveler";
    private static final String MULTICLUSTER_OPTION = "--multicluster";
    private static final String NODE_POLL_MIN_OPTION = "--node_polling_min";
    private static final String NODE_POLL_MAX_OPTION = "--node_polling_max";
    private static final String JOB_POLL_OPTION = "--job_polling";
    private static final String LIB_OVERRIDE_OPTION = "--lib_override";
    private static final String TRACE_OPTION = "--trace";
    private static final String RUN_MINIPROXY_OPTION = "--runMiniproxy";
    private Composite optionsPane;
    private Button loadLevelerOption;
    private Button suspendOption;
    private Button runMiniproxy;
    private Button libOverrideBrowse;
    private Button llModeLocal;
    private Button llModeMulticluster;
    private Button llModeDefault;
    private Text nodePollMinInterval;
    private Text nodePollMaxInterval;
    private Text jobPollInterval;
    private Text libOverridePath;
    private Group llModeGroup;
    private Composite llOverrideBox;
    private Combo debugLevel;
    private Label llLabel;
    private Label debugLabel;
    private Label suspendLabel;
    private Label runMiniproxyLabel;
    private Label libOverrideLabel;
    private Label llModeLabel;
    private Label nodePollMinLabel;
    private Label nodePollMaxLabel;
    private Label jobPollLabel;
    private Shell parentShell;
    private String proxyOptions;
    private IPEResourceManagerConfiguration config;
    private IRemoteServices remoteService;
    private IRemoteUIServices remoteUIService;
    private IRemoteConnection remoteConnection;
    private IRemoteConnectionManager connMgr;
    private EventMonitor eventMonitor;

    public PEResourceManagerOptionDialog(Shell parent, IPEResourceManagerConfiguration config, String initialOptions) {
        super(parent);
        this.parentShell = parent;
        this.config = config;
        this.setInitialOptions(initialOptions);
        this.create();
    }

    public Preferences getPreferences() {
        return PEPreferenceManager.getPreferences();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("PEDialogs.InvocationOptionsTitle"));
        this.eventMonitor = new EventMonitor();
        this.getPreferences();
        this.optionsPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        this.optionsPane.setLayout((Layout)layout);
        this.llLabel = new Label(this.optionsPane, 0);
        this.llLabel.setText(Messages.getString("PEDialogs.LoadLevelerOptionLabel"));
        this.loadLevelerOption = new Button(this.optionsPane, 32);
        String preferenceValue = this.config.getUseLoadLeveler();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.loadLevelerOption.setSelection(true);
        }
        this.llModeLabel = new Label(this.optionsPane, 0);
        this.llModeLabel.setText(Messages.getString("PEDialogs.LLRunMode"));
        this.llModeGroup = new Group(this.optionsPane, 16);
        GridLayout modeLayout = new GridLayout(2, true);
        this.llModeGroup.setLayout((Layout)modeLayout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.llModeGroup.setLayoutData((Object)gd);
        this.llModeLocal = new Button((Composite)this.llModeGroup, 16);
        this.llModeLocal.setText(Messages.getString("PEDialogs.llModeLocal"));
        this.llModeMulticluster = new Button((Composite)this.llModeGroup, 16);
        this.llModeMulticluster.setText(Messages.getString("PEDialogs.llModeMulticluster"));
        this.llModeDefault = new Button((Composite)this.llModeGroup, 16);
        this.llModeDefault.setText(Messages.getString("PEDialogs.llModeDefault"));
        this.llModeDefault.setSelection(false);
        this.llModeLocal.setSelection(false);
        this.llModeMulticluster.setSelection(false);
        preferenceValue = this.config.getLoadLevelerMode();
        if (preferenceValue != null) {
            if (preferenceValue.equals("y")) {
                this.llModeMulticluster.setSelection(true);
            } else if (preferenceValue.equals("n")) {
                this.llModeLocal.setSelection(true);
            } else {
                this.llModeDefault.setSelection(true);
            }
        } else {
            this.llModeDefault.setSelection(true);
        }
        this.nodePollMinLabel = new Label(this.optionsPane, 0);
        this.nodePollMinLabel.setText(Messages.getString("PEDialogs.minNodePollInterval"));
        this.nodePollMinInterval = new Text(this.optionsPane, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMinInterval.setLayoutData((Object)gd);
        preferenceValue = this.config.getNodeMinPollInterval();
        if (preferenceValue != null) {
            this.nodePollMinInterval.setText(preferenceValue);
        }
        this.nodePollMaxLabel = new Label(this.optionsPane, 0);
        this.nodePollMaxLabel.setText(Messages.getString("PEDialogs.maxNodePollInterval"));
        this.nodePollMaxInterval = new Text(this.optionsPane, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMaxInterval.setLayoutData((Object)gd);
        preferenceValue = this.config.getNodeMaxPollInterval();
        if (preferenceValue != null) {
            this.nodePollMaxInterval.setText(preferenceValue);
        }
        this.jobPollLabel = new Label(this.optionsPane, 0);
        this.jobPollLabel.setText(Messages.getString("PEDialogs.jobPollInterval"));
        this.jobPollInterval = new Text(this.optionsPane, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.jobPollInterval.setLayoutData((Object)gd);
        preferenceValue = this.config.getJobPollInterval();
        if (preferenceValue != null) {
            this.jobPollInterval.setText(preferenceValue);
        }
        this.libOverrideLabel = new Label(this.optionsPane, 0);
        this.libOverrideLabel.setText(Messages.getString("PEDialogs.libOverrideLabel"));
        this.llOverrideBox = new Composite(this.optionsPane, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.llOverrideBox.setLayoutData((Object)gd);
        GridLayout libPathLayout = new GridLayout(2, false);
        libPathLayout.marginLeft = 0;
        libPathLayout.marginRight = 0;
        libPathLayout.marginWidth = 0;
        this.llOverrideBox.setLayout((Layout)libPathLayout);
        this.libOverridePath = new Text(this.llOverrideBox, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.libOverridePath.setLayoutData((Object)gd);
        this.libOverrideBrowse = new Button(this.llOverrideBox, 8);
        this.libOverrideBrowse.setText(Messages.getString("PEDialogs.browse"));
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        this.libOverrideBrowse.setLayoutData((Object)gd);
        preferenceValue = this.config.getLibraryOverride();
        if (preferenceValue != null) {
            this.libOverridePath.setText(preferenceValue);
        }
        this.runMiniproxyLabel = new Label(this.optionsPane, 0);
        this.runMiniproxyLabel.setText(Messages.getString("PEDialogs.MiniproxyLabel"));
        this.runMiniproxy = new Button(this.optionsPane, 32);
        preferenceValue = this.config.getRunMiniproxy();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.runMiniproxy.setSelection(true);
        }
        this.debugLabel = new Label(this.optionsPane, 0);
        this.debugLabel.setText(Messages.getString("PEDialogs.TraceLevelLabel"));
        this.debugLevel = new Combo(this.optionsPane, 8);
        this.debugLevel.add("None");
        this.debugLevel.add("Function");
        this.debugLevel.add("Detail");
        preferenceValue = this.config.getDebugLevel();
        if (preferenceValue != null) {
            this.debugLevel.setText(preferenceValue);
        }
        this.suspendLabel = new Label(this.optionsPane, 0);
        this.suspendLabel.setText(Messages.getString("PEDialogs.SuspendLabel"));
        this.suspendOption = new Button(this.optionsPane, 32);
        preferenceValue = this.config.getSuspendProxy();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.suspendOption.setSelection(true);
        }
        if (!this.loadLevelerOption.getSelection()) {
            this.setLLWidgetEnableState(false);
        }
        this.loadLevelerOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.suspendOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeLocal.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeMulticluster.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llModeDefault.addSelectionListener((SelectionListener)this.eventMonitor);
        this.nodePollMinInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.nodePollMaxInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.jobPollInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverridePath.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverrideBrowse.addSelectionListener((SelectionListener)this.eventMonitor);
        this.runMiniproxy.addSelectionListener((SelectionListener)this.eventMonitor);
        this.suspendOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.debugLevel.addSelectionListener((SelectionListener)this.eventMonitor);
        this.validateInput(null);
        return this.optionsPane;
    }

    private void setLLWidgetEnableState(boolean state) {
        this.llModeLocal.setEnabled(state);
        this.llModeMulticluster.setEnabled(state);
        this.llModeDefault.setEnabled(state);
        this.nodePollMinInterval.setEnabled(state);
        this.nodePollMaxInterval.setEnabled(state);
        this.jobPollInterval.setEnabled(state);
        this.libOverridePath.setEnabled(state);
        this.libOverrideBrowse.setEnabled(state);
    }

    protected boolean validateInput(Object eventSource) {
        this.proxyOptions = "";
        this.setErrorMessage(null);
        if (this.loadLevelerOption.getSelection()) {
            this.proxyOptions = String.valueOf(this.proxyOptions) + USE_LOADLEVELER_OPTION + " ";
            this.config.setUseLoadLeveler("Y");
            this.proxyOptions = String.valueOf(this.proxyOptions) + MULTICLUSTER_OPTION + "=";
            String multiclusterMode = this.llModeDefault.getSelection() ? "d" : (this.llModeLocal.getSelection() ? "n" : "y");
            this.proxyOptions = String.valueOf(this.proxyOptions) + multiclusterMode + " ";
            this.config.setLoadLevelerMode(multiclusterMode);
            String widgetValue = this.nodePollMinInterval.getText().trim();
            if (widgetValue.length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.getString("PEDialogs.invalidMinPollInterval"));
                    return false;
                }
                this.proxyOptions = String.valueOf(this.proxyOptions) + NODE_POLL_MIN_OPTION + "=" + widgetValue + " ";
            }
            this.config.setNodeMinPollInterval(widgetValue);
            widgetValue = this.nodePollMaxInterval.getText().trim();
            if (widgetValue.length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.getString("PEDialogs.invalidMaxPollInterval"));
                    return false;
                }
                this.proxyOptions = String.valueOf(this.proxyOptions) + NODE_POLL_MAX_OPTION + "=" + widgetValue + " ";
            }
            this.config.setNodeMaxPollInterval(widgetValue);
            widgetValue = this.jobPollInterval.getText().trim();
            if (widgetValue.length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.getString("PEDialogs.invalidJobPollInterval"));
                    return false;
                }
                this.proxyOptions = String.valueOf(this.proxyOptions) + JOB_POLL_OPTION + "=" + widgetValue + " ";
            }
            this.config.setJobPollInterval(widgetValue);
            widgetValue = this.libOverridePath.getText().trim();
            if (widgetValue.length() > 0 && eventSource == this.libOverridePath) {
                IFileStore remoteResource;
                IFileInfo fileInfo;
                this.remoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.config.getRemoteServicesId());
                this.connMgr = this.remoteService.getConnectionManager();
                this.remoteConnection = this.connMgr.getConnection(this.config.getConnectionName());
                Path testPath = new Path(widgetValue);
                if (!testPath.isValidPath(widgetValue)) {
                    this.setErrorMessage(Messages.getString("PEDialogs.invalidLibraryPath"));
                }
                if (!(fileInfo = (remoteResource = this.remoteService.getFileManager(this.remoteConnection).getResource(testPath.toString())).fetchInfo()).exists() || !fileInfo.isDirectory()) {
                    this.setErrorMessage(Messages.getString("PEDialogs.invalidLibraryPath"));
                }
                this.proxyOptions = String.valueOf(this.proxyOptions) + LIB_OVERRIDE_OPTION + "=" + widgetValue + " ";
            }
            this.config.setLibraryOverride(widgetValue);
        } else {
            this.config.setUseLoadLeveler("N");
        }
        String traceOpt = this.debugLevel.getText();
        if (traceOpt.length() > 0) {
            this.proxyOptions = String.valueOf(this.proxyOptions) + TRACE_OPTION + "=" + traceOpt + " ";
            this.config.setDebugLevel(traceOpt);
        }
        if (this.suspendOption.getSelection()) {
            this.proxyOptions = String.valueOf(this.proxyOptions) + SUSPEND_AT_STARTUP_OPTION;
            this.config.setSuspendProxy("Y");
        } else {
            this.config.setSuspendProxy("N");
        }
        if (this.runMiniproxy.getSelection()) {
            this.proxyOptions = String.valueOf(this.proxyOptions) + RUN_MINIPROXY_OPTION + " ";
            this.config.setRunMiniproxy("Y");
        } else {
            this.config.setRunMiniproxy("N");
        }
        this.config.setInvocationOptions(this.proxyOptions);
        return true;
    }

    public String getValue() {
        return this.proxyOptions;
    }

    public void setInitialOptions(String initialOptions) {
        StringTokenizer options = new StringTokenizer(initialOptions, " ");
        this.config.setSuspendProxy("N");
        this.config.setRunMiniproxy("N");
        while (options.hasMoreTokens()) {
            String[] currentToken = options.nextToken().split("=");
            if (currentToken.length == 1) {
                if (currentToken[0].equals(SUSPEND_AT_STARTUP_OPTION)) {
                    this.config.setSuspendProxy("Y");
                    continue;
                }
                if (currentToken[0].equals(RUN_MINIPROXY_OPTION)) {
                    this.config.setRunMiniproxy("Y");
                    continue;
                }
                if (!currentToken[0].equals(USE_LOADLEVELER_OPTION)) continue;
                this.config.setUseLoadLeveler("Y");
                continue;
            }
            if (currentToken[0].equals(MULTICLUSTER_OPTION)) {
                this.config.setLoadLevelerMode(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(NODE_POLL_MIN_OPTION)) {
                this.config.setNodeMinPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(NODE_POLL_MAX_OPTION)) {
                this.config.setNodeMaxPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(JOB_POLL_OPTION)) {
                this.config.setJobPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(LIB_OVERRIDE_OPTION)) {
                this.config.setLibraryOverride(currentToken[1]);
                continue;
            }
            if (!currentToken[0].equals(TRACE_OPTION)) continue;
            this.config.setDebugLevel(currentToken[1]);
        }
    }

    private class EventMonitor
    implements SelectionListener,
    ModifyListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == PEResourceManagerOptionDialog.this.loadLevelerOption) {
                if (PEResourceManagerOptionDialog.this.loadLevelerOption.getSelection()) {
                    PEResourceManagerOptionDialog.this.setLLWidgetEnableState(true);
                } else {
                    PEResourceManagerOptionDialog.this.setLLWidgetEnableState(false);
                }
            }
            if (e.getSource() == PEResourceManagerOptionDialog.this.libOverrideBrowse) {
                String selectedFile = null;
                if (PEResourceManagerOptionDialog.this.remoteUIService != null) {
                    IRemoteUIFileManager fmgr = PEResourceManagerOptionDialog.this.remoteUIService.getUIFileManager();
                    fmgr.setConnection(PEResourceManagerOptionDialog.this.remoteConnection);
                    selectedFile = fmgr.browseDirectory(PEResourceManagerOptionDialog.this.parentShell, Messages.getString("PEDialogs.librarySelectorTitle"), "/", 0).toString();
                }
                if (selectedFile != null) {
                    PEResourceManagerOptionDialog.this.libOverridePath.setText(selectedFile);
                }
            } else {
                PEResourceManagerOptionDialog.this.validateInput(e.getSource());
            }
        }

        public void modifyText(ModifyEvent e) {
            PEResourceManagerOptionDialog.this.validateInput(e.getSource());
        }
    }
}

