/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.ptp.remotetools.utils.stream.IStreamListener;

public class StreamObserver
extends Thread {
    private InputStream input;
    private boolean killed;
    private String name;
    private IStreamListener listener;
    static final int BUFFER_SIZE = 100;

    public StreamObserver(InputStream input, IStreamListener listener, String name) {
        this.name = name;
        this.input = input;
        this.listener = listener;
        this.setName(name);
    }

    public StreamObserver(InputStream input, IStreamListener listener) {
        this.name = this.getClass().getName();
        this.input = input;
        this.listener = listener;
        this.setName(this.name);
    }

    public synchronized void kill() {
        this.killed = true;
    }

    void log(String s) {
    }

    void streamClosed() {
        this.log("Stream closed");
        this.listener.streamClosed();
    }

    void streamError(Exception e) {
        this.log("Recovered from exception: " + e.getMessage());
        this.listener.streamError(e);
    }

    void newBytes(byte[] buffer, int length) {
        this.log("Received: " + Integer.toString(length) + " bytes");
        this.listener.newBytes(buffer, length);
    }

    public void run() {
        byte[] buffer = new byte[250];
        this.log("Started observing");
        while (!this.killed) {
            try {
                int bytes = this.input.read(buffer);
                if (bytes > 0) {
                    this.newBytes(buffer, bytes);
                    continue;
                }
                if (bytes != -1) continue;
                this.streamClosed();
            }
            catch (IOException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                if (e instanceof EOFException) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
            }
            break;
        }
        this.log("Finished observing");
    }
}

