/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandlerBase;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.common.util.ViewActivater;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPAnalysisManager;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.core.Messages;
import org.eclipse.ptp.pldt.openmp.core.OpenMPArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ptp.pldt.openmp.core.OpenMPScanReturn;
import org.eclipse.ptp.pldt.openmp.core.analysis.OpenMPCASTVisitor;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAnalyseOpenMPcommandHandler
extends RunAnalyseHandlerBase {
    private static final String OPENMP_DIRECTIVE = Messages.RunAnalyseOpenMPcommandHandler_OPENMP_DIRECTIVE;
    private static final boolean traceOn = false;

    public RunAnalyseOpenMPcommandHandler() {
        super("OpenMP", (ArtifactMarkingVisitor)new OpenMPArtifactMarkingVisitor("org.eclipse.ptp.pldt.openmp.core.openMPMarker"), "org.eclipse.ptp.pldt.openmp.core.openMPMarker");
    }

    public ScanReturn doArtifactAnalysis(ITranslationUnit tu, List<String> includes) {
        OpenMPScanReturn msr = new OpenMPScanReturn();
        String fileName = tu.getElementName();
        IASTTranslationUnit atu = null;
        try {
            ILanguage lang = tu.getLanguage();
            atu = tu.getAST();
            if (lang.getId().equals("org.eclipse.cdt.core.gcc")) {
                atu.accept((ASTVisitor)new OpenMPCASTVisitor(includes, fileName, msr));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IResource res = tu.getResource();
        IFile file = null;
        if (res instanceof IFile) {
            file = (IFile)res;
        } else {
            System.out.println("RunAnalyseOpenMP.doArtifactAnalysis, file cast won't work...");
        }
        this.processOpenMPPragmas(msr, atu, file);
        return msr;
    }

    protected void processOpenMPPragmas(OpenMPScanReturn msr, IASTTranslationUnit astTransUnit, IFile iFile) {
        OpenMPAnalysisManager omgr = new OpenMPAnalysisManager(astTransUnit, iFile);
        PASTNode[] pList = omgr.getPAST();
        int i = 0;
        while (i < pList.length) {
            if (pList[i] instanceof PASTOMPPragma) {
                PASTOMPPragma pop = (PASTOMPPragma)pList[i];
                SourceInfo si = this.getSourceInfo((PASTNode)pop, 0);
                Artifact a = new Artifact(pop.getFilename(), pop.getStartingLine(), pop.getStartLocation(), pop.getContent(), OPENMP_DIRECTIVE, si, (Object)pop);
                msr.addArtifact(a);
            }
            ++i;
        }
        msr.addProblems(OpenMPErrorManager.getCurrentErrorManager().getErrors());
    }

    private SourceInfo getSourceInfo(PASTNode pastNode, int constructType) {
        SourceInfo sourceInfo = null;
        IASTNodeLocation[] locations = pastNode.getNodeLocations();
        if (locations.length == 1) {
            IASTFileLocation astFileLocation = null;
            if (locations[0] instanceof IASTFileLocation) {
                astFileLocation = (IASTFileLocation)locations[0];
                sourceInfo = new SourceInfo();
                sourceInfo.setStartingLine(astFileLocation.getStartingLineNumber());
                sourceInfo.setStart(astFileLocation.getNodeOffset());
                sourceInfo.setEnd(astFileLocation.getNodeOffset() + astFileLocation.getNodeLength());
                sourceInfo.setConstructType(constructType);
            }
        }
        return sourceInfo;
    }

    protected void processResults(ScanReturn results, IResource resource) {
        assert (results instanceof OpenMPScanReturn);
        OpenMPScanReturn osr = (OpenMPScanReturn)results;
        List<Artifact> artifacts = osr.getOpenMPList();
        this.visitor.visitFile(resource, artifacts);
        this.removeProblemMarkers(resource);
        LinkedList<OpenMPError> problems = osr.getProblems();
        try {
            Iterator i = problems.iterator();
            while (i.hasNext()) {
                this.processProblem((OpenMPError)i.next(), resource);
            }
        }
        catch (CoreException e) {
            System.out.println("RunAnalysisOpenMP.processResults exception: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private void processProblem(OpenMPError problem, IResource resource) throws CoreException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", problem.getDescription());
        attrs.put("resource", problem.getFilename());
        attrs.put("infoldername", problem.getPath());
        attrs.put("location", new Integer(problem.getLineno()));
        attrs.put("problem", problem);
        MarkerUtilities.createMarker((IResource)resource, attrs, (String)"org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker");
    }

    private void removeProblemMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker", false, 2);
        }
        catch (CoreException e) {
            System.out.println((Object)e);
            System.out.println(e.toString());
            System.out.println("Problem deleting markers on OMP Problems: " + resource.getProjectRelativePath());
        }
    }

    protected List<String> getIncludePath() {
        return OpenMPPlugin.getDefault().getIncludeDirs();
    }

    protected void activateArtifactView() {
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.openmp.core.views.OpenMPArtifactView");
    }

    protected void activateProblemsView() {
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.openmp.ui.pv.views.OpenMPProblemsView");
    }
}

