/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.ProblemSearchElement;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchTreeContentProvider;
import org.eclipse.ptp.internal.rdt.ui.search.TypeInfoSearchElement;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class RemoteSearchLabelProvider
extends LabelProvider {
    private final AbstractTextSearchViewPage fPage;
    private final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(20);
    private final CUILabelProvider fCElementLabelProvider = new CUILabelProvider(0, 2);

    public RemoteSearchLabelProvider(AbstractTextSearchViewPage page) {
        this.fPage = page;
    }

    public Image getImage(Object element) {
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getImage((Object)((TypeInfoSearchElement)element).getTypeInfo());
        }
        if (element instanceof ProblemSearchElement) {
            return CPluginImages.get((String)"org.eclipse.cdt.ui.warning_obj.gif");
        }
        if (element instanceof IIndexFileLocation || element instanceof URI) {
            return CPluginImages.get((String)"org.eclipse.cdt.ui.include_obj.gif");
        }
        if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
            return CPluginImages.get((String)"org.eclipse.cdt.ui.includes_container.gif");
        }
        if (element instanceof IPath) {
            return CPluginImages.get((String)"org.eclipse.cdt.ui.hfolder_obj.gif");
        }
        if (element instanceof IStatus) {
            IStatus status = (IStatus)element;
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            switch (status.getSeverity()) {
                case 2: {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                case 4: {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return sharedImages.getImage("IMG_OBJS_INFO_TSK");
        }
        return this.fCElementLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        IPath path;
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getText((Object)((TypeInfoSearchElement)element).getTypeInfo());
        }
        if (element instanceof ProblemSearchElement) {
            ProblemSearchElement pse = (ProblemSearchElement)element;
            return ASTSignatureUtil.getProblemMessage((int)pse.getProblemID(), (String)pse.getDetail());
        }
        if (element instanceof IPath) {
            return ((IPath)element).toString();
        }
        if (element instanceof IIndexFileLocation && (path = RemoteSearchTreeContentProvider.getAbsolutePath((IIndexFileLocation)element)) != null) {
            return path.lastSegment();
        }
        if (element instanceof URI) {
            return ((URI)element).toString();
        }
        if (element instanceof IStatus) {
            return ((IStatus)element).getMessage();
        }
        return this.fCElementLabelProvider.getText(element);
    }

    protected int getMatchCount(Object element) {
        return this.fPage.getInput().getMatchCount(element);
    }
}

