/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.resources.EFSFileStorage;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchElement;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchQueryAdapter;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.part.FileEditorInput;

public class RemoteSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private RemoteSearchQueryAdapter fQuery;
    private boolean indexerBusy;

    public RemoteSearchResult(RemoteSearchQueryAdapter query) {
        this.fQuery = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    private String getFileName(IEditorPart editor) {
        ILocationProvider provider;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IPath location = fileInput.getFile().getLocation();
            if (location != null) {
                return fileInput.getFile().getLocation().toOSString();
            }
            return fileInput.getFile().getLocationURI().toString();
        }
        if (input instanceof ExternalEditorInput) {
            ExternalEditorInput extInput = (ExternalEditorInput)input;
            if (extInput.getPath() != null) {
                return extInput.getPath().toOSString();
            }
            return extInput.getURI().toString();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                if (storage.getFullPath() != null) {
                    return storage.getFullPath().toOSString();
                }
            }
            catch (CoreException coreException) {}
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            return path.toOSString();
        }
        if ((provider = (ILocationProvider)input.getAdapter(ILocationProvider.class)) != null) {
            IPath path = provider.getPath((Object)input);
            return path.toOSString();
        }
        return null;
    }

    private URI getLocationURI(IEditorPart editor) {
        ILocationProviderExtension provider;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            return fileInput.getFile().getLocationURI();
        }
        if (input instanceof ExternalEditorInput) {
            ExternalEditorInput extInput = (ExternalEditorInput)input;
            return extInput.getTranslationUnit().getLocationURI();
        }
        if (input instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                if (storage instanceof EFSFileStorage) {
                    return ((EFSFileStorage)storage).getLocationURI();
                }
            }
            catch (CoreException coreException) {}
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            return URIUtil.toURI((IPath)path);
        }
        if ((provider = (ILocationProviderExtension)input.getAdapter(ILocationProviderExtension.class)) != null) {
            return provider.getURI((Object)input);
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        URI uri = this.getLocationURI(editor);
        if (uri != null && match instanceof RemoteSearchMatchAdapter) {
            return uri.normalize().equals(((RemoteSearchMatchAdapter)match).getLocation().getURI().normalize());
        }
        return false;
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, String filename) throws CoreException {
        Path pfilename = new Path(filename);
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            if (pfilename.equals((Object)IndexLocationFactory.getAbsolutePath((IIndexFileLocation)((RemoteSearchElement)elements[i]).getLocation()))) {
                Match[] matches = result.getMatches(elements[i]);
                int j = 0;
                while (j < matches.length) {
                    if (matches[j] instanceof RemoteSearchMatchAdapter) {
                        list.add(matches[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, URI locationURI) throws CoreException {
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            if (locationURI.normalize().equals(((RemoteSearchElement)elements[i]).getLocation().getURI().normalize())) {
                Match[] matches = result.getMatches(elements[i]);
                int j = 0;
                while (j < matches.length) {
                    if (matches[j] instanceof RemoteSearchMatchAdapter) {
                        list.add(matches[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        try {
            URI uri = this.getLocationURI(editor);
            if (uri != null) {
                return this.computeContainedMatches(result, uri);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        try {
            URI uri = file.getLocationURI();
            return this.computeContainedMatches(result, uri);
        }
        catch (CoreException e) {
            CUIPlugin.log((Throwable)e);
            return new Match[0];
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IIndexName) {
            IIndexName name = (IIndexName)element;
            try {
                IIndexFileLocation location = name.getFile().getLocation();
                if (location.getFullPath() != null) {
                    return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()));
                }
                return ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location.getURI())[0];
            }
            catch (CoreException coreException) {}
        } else if (element instanceof RemoteSearchElement) {
            RemoteSearchElement searchElement = (RemoteSearchElement)element;
            IIndexFileLocation location = searchElement.getLocation();
            if (location.getFullPath() != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location.getFullPath()));
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(location.getURI());
            if (files != null && files.length > 0) {
                return files[0];
            }
        }
        return null;
    }

    public String getLabel() {
        String label = this.fQuery.getLabel();
        String countLabel = Messages.format((String)CSearchMessages.CSearchResultCollector_matches, (Object[])new Object[]{new Integer(this.getMatchCount())});
        return String.valueOf(label) + " " + countLabel;
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public RemoteSearchQueryAdapter getQuery() {
        return this.fQuery;
    }

    public void setIndexerBusy(boolean b) {
        this.indexerBusy = b;
    }

    public boolean wasIndexerBusy() {
        return this.indexerBusy;
    }
}

