/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dstore.core.client.ClientConnection;
import org.eclipse.dstore.core.client.ConnectionStatus;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.subsystems.DStoreServerDefaults;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;

public class DStoreServerRunner
extends Job {
    private boolean DEBUG = true;
    private List<String> fCommand;
    private String workDir = null;
    private Map<String, String> fEnv = new HashMap<String, String>();
    private DStoreServerState fServerState = DStoreServerState.STARTING;
    private IRemoteServices fRemoteServices;
    private IRemoteConnection fRemoteConnection;
    private IRemoteProcess fRemoteProcess;
    private ClientConnection fDStoreConnection = null;
    private int fPort;
    private static final String fSuccessString = "Server Started Successfully";

    public DStoreServerRunner(IRemoteServices services, IRemoteConnection connection) {
        super("DStoreServerRunner");
        this.setPriority(30);
        this.setSystem(!this.DEBUG);
        this.fRemoteServices = services;
        this.fRemoteConnection = connection;
    }

    public DataStore getDataStore() {
        if (this.fDStoreConnection == null) {
            this.fDStoreConnection = new ClientConnection(this.fRemoteConnection.getName());
        }
        return this.fDStoreConnection.getDataStore();
    }

    public synchronized DStoreServerState getServerState() {
        return this.fServerState;
    }

    public void setCommand(String command) {
        if (command != null) {
            this.fCommand = Arrays.asList(command.split(" "));
        }
    }

    public void setEnv(String env) {
        if (env != null) {
            String[] stringArray = env.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String vars = stringArray[n2];
                String[] envVar = vars.split("=");
                if (envVar.length == 2) {
                    this.fEnv.put(envVar[0], envVar[1]);
                }
                ++n2;
            }
        }
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public synchronized boolean startServer() {
        if (this.fServerState == DStoreServerState.RUNNING) {
            return false;
        }
        if (this.fServerState == DStoreServerState.FINISHED) {
            this.setServerState(DStoreServerState.STARTING);
            this.fPort = 0;
        }
        if (!this.fRemoteConnection.isOpen()) {
            try {
                this.fRemoteConnection.open(null);
            }
            catch (RemoteConnectionException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.schedule();
        while (this.getServerState() == DStoreServerState.STARTING) {
            try {
                ((Object)((Object)this)).wait(500L);
            }
            catch (InterruptedException e) {
                if (DStoreServerDefaults.DSTORE_TRACING) {
                    System.err.println("DSTORE SERVER: InterruptedException " + e.getLocalizedMessage());
                }
                return false;
            }
        }
        if (this.fServerState == DStoreServerState.RUNNING) {
            int port;
            try {
                port = this.fRemoteConnection.forwardLocalPort("localhost", this.fPort, null);
            }
            catch (RemoteConnectionException e) {
                if (DStoreServerDefaults.DSTORE_TRACING) {
                    System.err.println("DSTORE SERVER: port fowarding failed " + e.getLocalizedMessage());
                }
                return false;
            }
            this.fDStoreConnection.setHost("localhost");
            this.fDStoreConnection.setPort(Integer.toString(port));
            ConnectionStatus status = this.fDStoreConnection.connect(null, 0);
            DataStore dataStore = this.fDStoreConnection.getDataStore();
            dataStore.showTicket(null);
            dataStore.registerLocalClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            return status.isConnected();
        }
        return false;
    }

    protected void canceling() {
        this.terminateServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        DStoreServerRunner dStoreServerRunner;
        IStatus iStatus;
        IRemoteProcessBuilder builder;
        block50: {
            block49: {
                assert (this.fCommand != null);
                assert (this.fRemoteProcess == null);
                if (!monitor.isCanceled()) break block49;
                IStatus iStatus2 = Status.CANCEL_STATUS;
                DStoreServerRunner dStoreServerRunner2 = this;
                synchronized (dStoreServerRunner2) {
                    this.fRemoteProcess = null;
                    if (this.fDStoreConnection != null) {
                        this.fDStoreConnection.disconnect();
                        this.fDStoreConnection = null;
                    }
                }
                return iStatus2;
            }
            IRemoteFileManager fileManager = this.fRemoteServices.getFileManager(this.fRemoteConnection);
            IFileStore directory = null;
            if (this.workDir != null) {
                directory = fileManager.getResource(this.workDir);
            }
            builder = this.fRemoteServices.getProcessBuilder(this.fRemoteConnection, this.fCommand);
            if (directory != null) {
                builder.directory(directory);
            }
            builder.environment().putAll(this.fEnv);
            if (!monitor.isCanceled()) break block50;
            IStatus iStatus3 = Status.CANCEL_STATUS;
            DStoreServerRunner dStoreServerRunner3 = this;
            synchronized (dStoreServerRunner3) {
                this.fRemoteProcess = null;
                if (this.fDStoreConnection != null) {
                    this.fDStoreConnection.disconnect();
                    this.fDStoreConnection = null;
                }
            }
            return iStatus3;
        }
        try {
            DStoreServerRunner dStoreServerRunner4 = this;
            synchronized (dStoreServerRunner4) {
                this.fRemoteProcess = builder.start();
            }
            if (DStoreServerDefaults.DSTORE_TRACING) {
                final BufferedReader stdout = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getInputStream()));
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            String output;
                            while ((output = stdout.readLine()) != null) {
                                System.out.println("DSTORE SERVER stdout: " + output);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }, "dstore server stdout").start();
            }
            final BufferedReader stderr = new BufferedReader(new InputStreamReader(this.fRemoteProcess.getErrorStream()));
            new Thread(new Runnable(){

                public void run() {
                    try {
                        String output;
                        while ((output = stderr.readLine()) != null) {
                            if (DStoreServerRunner.this.getServerState() == DStoreServerState.STARTING && output.startsWith(DStoreServerRunner.fSuccessString) && (output = stderr.readLine()) != null && output.matches("^[0-9]+$")) {
                                DStoreServerRunner.this.fPort = Integer.parseInt(output);
                                DStoreServerRunner.this.setServerState(DStoreServerState.RUNNING);
                                if (DStoreServerDefaults.DSTORE_TRACING) {
                                    System.err.println("DSTORE SERVER started on port " + output);
                                }
                            }
                            if (!DStoreServerDefaults.DSTORE_TRACING) continue;
                            System.err.println("DSTORE SERVER stderr: " + output);
                        }
                    }
                    catch (IOException iOException) {}
                }
            }, "dstore server stderr").start();
            while (!this.fRemoteProcess.isCompleted() && !monitor.isCanceled()) {
                DStoreServerRunner dStoreServerRunner5 = this;
                synchronized (dStoreServerRunner5) {
                    try {
                        ((Object)((Object)this)).wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.fRemoteProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (this.fRemoteProcess.exitValue() != 0 && !monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(4, UIPlugin.getPluginId(), NLS.bind((String)"DStore server finished with exit code {0}", (Object)this.fRemoteProcess.exitValue())));
            }
            this.setServerState(DStoreServerState.FINISHED);
            iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            dStoreServerRunner = this;
        }
        catch (CoreException e) {
            this.setServerState(DStoreServerState.ERROR);
            IStatus iStatus4 = e.getStatus();
            DStoreServerRunner dStoreServerRunner6 = this;
            synchronized (dStoreServerRunner6) {
                this.fRemoteProcess = null;
                if (this.fDStoreConnection != null) {
                    this.fDStoreConnection.disconnect();
                    this.fDStoreConnection = null;
                }
            }
            return iStatus4;
        }
        catch (IOException e2) {
            this.setServerState(DStoreServerState.ERROR);
            Status status = new Status(4, UIPlugin.getPluginId(), "failed to start dstore server", (Throwable)e2);
            DStoreServerRunner dStoreServerRunner7 = this;
            {
                catch (Throwable throwable) {
                    DStoreServerRunner dStoreServerRunner8 = this;
                    synchronized (dStoreServerRunner8) {
                        this.fRemoteProcess = null;
                        if (this.fDStoreConnection != null) {
                            this.fDStoreConnection.disconnect();
                            this.fDStoreConnection = null;
                        }
                    }
                    throw throwable;
                }
            }
            synchronized (dStoreServerRunner7) {
                this.fRemoteProcess = null;
                if (this.fDStoreConnection != null) {
                    this.fDStoreConnection.disconnect();
                    this.fDStoreConnection = null;
                }
            }
            return status;
        }
        synchronized (dStoreServerRunner) {
            this.fRemoteProcess = null;
            if (this.fDStoreConnection != null) {
                this.fDStoreConnection.disconnect();
                this.fDStoreConnection = null;
            }
        }
        return iStatus;
    }

    protected synchronized void setServerState(DStoreServerState state) {
        if (DStoreServerDefaults.DSTORE_TRACING) {
            System.err.println("DSTORE SERVER new state: " + state.toString());
        }
        this.fServerState = state;
        ((Object)((Object)this)).notifyAll();
    }

    protected synchronized void terminateServer() {
        if (this.fServerState == DStoreServerState.RUNNING && this.fRemoteProcess != null) {
            this.fRemoteProcess.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DStoreServerState {
        STARTING,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

